/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemSpell
extends Item {
    private final Supplier<? extends Spell> spell;

    public ItemSpell(Supplier<? extends Spell> spell, Item.Properties properties) {
        super(properties);
        this.spell = spell;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && this.useSpell(serverPlayer = (ServerPlayer)player, player.m_21120_(hand))) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public boolean useSpell(ServerPlayer player, ItemStack stack) {
        if (!this.getSpell().canUse(player.m_183503_(), (LivingEntity)player, stack)) {
            return false;
        }
        if (this.getSpell().useAction() != null) {
            return Platform.INSTANCE.getPlayerData((Player)player).map(d -> {
                if (player.m_36335_().m_41521_((Item)this, 0.0f) <= 0.0f) {
                    return d.getWeaponHandler().doWeaponAttack(this.getSpell().useAction(), stack, this.getSpell());
                }
                return false;
            }).orElse(false);
        }
        if (player.m_36335_().m_41521_((Item)this, 0.0f) <= 0.0f && this.spell.get().use(player.m_183503_(), (LivingEntity)player, stack)) {
            player.m_36335_().m_41524_((Item)this, this.getSpell().coolDown());
            this.spell.get().levelSkill(player);
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        if (this.spell.get() == ModSpells.EMPTY.get()) {
            list.add((Component)new TextComponent("WIP").m_130940_(ChatFormatting.DARK_RED));
        }
    }

    public Spell getSpell() {
        return this.spell.get();
    }
}

