/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.StaffData;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.ExtendedItem;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemStaffBase
extends Item
implements IItemUsable,
ExtendedItem,
IExtendedWeapon {
    public final EnumElement startElement;
    public final int amount;

    public ItemStaffBase(EnumElement startElement, int amount, Item.Properties props) {
        super(props);
        this.startElement = startElement;
        this.amount = Math.max(1, amount);
    }

    public int getChargeTime(ItemStack stack) {
        return Platform.INSTANCE.getStaffData(stack).map(StaffData::getChargeTime).orElse((int)((Attribute)ModAttributes.CHARGE_TIME.get()).m_22082_());
    }

    public int getStaffChargeTime(LivingEntity entity, ItemStack stack) {
        int time = this.getChargeTime(stack);
        if (ArmorEffect.hasArmorEffect(entity, (ArmorEffect)((Object)ModArmorEffects.MAGIC_RING.get()))) {
            time = (int)((double)time * 0.75);
        }
        return time;
    }

    public int chargeAmount(ItemStack stack) {
        return Platform.INSTANCE.getStaffData(stack).map(cap -> cap.getTier3Spell(stack) != null && ItemNBT.itemLevel(stack) >= 3 ? 3 : (cap.getTier2Spell(stack) != null ? 2 : (cap.getTier1Spell(stack) != null ? 1 : 0))).orElse(0);
    }

    public boolean resetAttackStrength(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean swingWeapon(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean onServerSwing(LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.STAFF.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.STAFF;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
    }

    public float getRange(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_RANGE.get());
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            int duration = stack.m_41779_() - remainingUseDuration;
            if (duration > 0 && duration / this.getStaffChargeTime(livingEntity, stack) <= this.chargeAmount(stack) && duration % this.getStaffChargeTime(livingEntity, stack) == 0) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (this.chargeAmount(stack) > 0) {
            if (!world.f_46443_) {
                if (this.getStaffChargeTime((LivingEntity)player, stack) <= 0) {
                    int level = Math.min(3, this.chargeAmount(stack));
                    Spell spell = this.getSpell(stack, level);
                    if (spell != null && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.STAFF_USE.get())), stack, spell));
                    }
                } else {
                    player.m_6672_(hand);
                }
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        int tier;
        int level;
        Spell spell;
        if (!world.f_46443_ && (spell = this.getSpell(stack, level = Math.min(tier = (this.m_8105_(stack) - timeLeft - 1) / this.getStaffChargeTime(entity, stack), this.chargeAmount(stack)))) != null) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.STAFF_USE.get())), stack, spell));
                return;
            }
            spell.use((ServerLevel)world, entity, stack);
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public Spell getSpell(ItemStack stack, int level) {
        StaffData cap = Platform.INSTANCE.getStaffData(stack).orElseThrow(() -> new NullPointerException("Error getting capability for staff item"));
        return switch (level) {
            case 3 -> cap.getTier3Spell(stack);
            case 2 -> cap.getTier2Spell(stack);
            case 1 -> cap.getTier1Spell(stack);
            default -> null;
        };
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }
}

