/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;

public record BiomeLootCondition(TagKey<Biome> tag) implements LootItemCondition
{
    public static LootItemCondition.Builder get(TagKey<Biome> tag) {
        return () -> new BiomeLootCondition(tag);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootRegistries.BIOME.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    public boolean test(LootContext ctx) {
        return ctx.m_78952_().m_204166_(new BlockPos((Vec3)ctx.m_165124_(LootContextParams.f_81460_))).m_203656_(this.tag);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<BiomeLootCondition> {
        public void serialize(JsonObject object, BiomeLootCondition condition, JsonSerializationContext context) {
            object.addProperty("biome_tag", condition.tag.f_203868_().toString());
        }

        public BiomeLootCondition deserialize(JsonObject obj, JsonDeserializationContext context) {
            String tag = GsonHelper.m_13906_((JsonObject)obj, (String)"biome_tag");
            if (tag.isEmpty()) {
                throw new JsonSyntaxException("Tag key is empty");
            }
            return new BiomeLootCondition((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(tag)));
        }
    }
}

