/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class CropWeaponLootFunction
extends LootItemConditionalFunction {
    private CropWeaponLootFunction(LootItemCondition[] conditions) {
        super(conditions);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLootRegistries.CROP_WEAPON_FUNCTION.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext ctx) {
        int i;
        if (!ItemNBT.shouldHaveStats(stack)) {
            return stack;
        }
        boolean equipment = stack.m_204117_(RunecraftoryTags.EQUIPMENT) && stack.m_41720_() instanceof ShieldItem;
        int level = 1;
        if (ctx.m_78936_(LootCtxParameters.ITEM_LEVEL_CONTEXT)) {
            level = (Integer)ctx.m_165124_(LootCtxParameters.ITEM_LEVEL_CONTEXT);
        } else if (ctx.m_78936_(LootContextParams.f_81461_) && ctx.m_78936_(LootContextParams.f_81460_)) {
            BlockPos blockPos = new BlockPos((Vec3)ctx.m_165124_(LootContextParams.f_81460_));
            level = FarmlandHandler.get(ctx.m_78952_().m_142572_()).getData(ctx.m_78952_(), blockPos).map(FarmlandData::getCropLevel).orElse(1);
        }
        List<Pair<ItemStack, ItemStat>> base = DataPackHandler.INSTANCE.itemStatManager().all(s -> !s.m_150930_(stack.m_41720_()) && equipment ? s.m_41720_() instanceof ShieldItem : s.m_204117_(RunecraftoryTags.UPGRADABLE_HELD));
        if (!base.isEmpty()) {
            CompoundTag tag = ItemNBT.getItemNBT(stack);
            if (tag == null) {
                tag = new CompoundTag();
            }
            tag.m_128379_("LightOre", true);
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128365_("runecraftory", (Tag)tag);
            ItemNBT.addUpgradeItem(stack, (ItemStack)base.get(ctx.m_78933_().nextInt(base.size())).getFirst(), true, equipment ? EnumCrafting.ARMOR : EnumCrafting.FORGE);
        }
        List<Pair<ItemStack, ItemStat>> bonus = DataPackHandler.INSTANCE.itemStatManager().all(s -> !s.m_204117_(RunecraftoryTags.WEAPONS) && !s.m_204117_(RunecraftoryTags.EQUIPMENT));
        int bonusAmount = ctx.m_78933_().nextInt(3) + 1;
        for (i = 0; i < bonusAmount; ++i) {
            ItemNBT.addUpgradeItem(stack, (ItemStack)bonus.get(ctx.m_78933_().nextInt(bonus.size())).getFirst(), true, equipment ? EnumCrafting.ARMOR : EnumCrafting.FORGE);
        }
        for (i = 1; i < level; ++i) {
            ItemNBT.addUpgradeItem(stack, (ItemStack)bonus.get(ctx.m_78933_().nextInt(bonus.size())).getFirst(), false, equipment ? EnumCrafting.ARMOR : EnumCrafting.FORGE);
        }
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CropWeaponLootFunction> {
        public void serialize(JsonObject obj, CropWeaponLootFunction func, JsonSerializationContext context) {
            super.m_6170_(obj, (LootItemConditionalFunction)func, context);
        }

        public CropWeaponLootFunction deserialize(JsonObject obj, JsonDeserializationContext ctx, LootItemCondition[] conditions) {
            return new CropWeaponLootFunction(conditions);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new CropWeaponLootFunction(this.m_80699_());
        }
    }
}

