/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record FriendPointCondition(int points) implements LootItemCondition
{
    public static LootItemCondition.Builder of(int points) {
        return () -> new FriendPointCondition(points);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootRegistries.FRIENDPOINTS.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public boolean test(LootContext ctx) {
        Object object = ctx.m_78953_(LootContextParams.f_81455_);
        if (object instanceof IBaseMob) {
            IBaseMob mob = (IBaseMob)object;
            UUID uuid = (UUID)ctx.m_78953_(LootCtxParameters.UUID_CONTEXT);
            if (uuid != null) {
                return mob.friendPoints(uuid) >= this.points;
            }
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<FriendPointCondition> {
        public void serialize(JsonObject object, FriendPointCondition condition, JsonSerializationContext context) {
            object.addProperty("points", (Number)condition.points);
        }

        public FriendPointCondition deserialize(JsonObject obj, JsonDeserializationContext context) {
            return new FriendPointCondition(GsonHelper.m_13824_((JsonObject)obj, (String)"points", (int)0));
        }
    }
}

