/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class ItemLevelLootFunction
extends LootItemConditionalFunction {
    private final List<WeightedLevel> levels;

    private ItemLevelLootFunction(LootItemCondition[] conditions, List<WeightedLevel> levels) {
        super(conditions);
        this.levels = levels;
    }

    public static LootItemConditionalFunction.Builder<Builder> getDef() {
        return new Builder().add(1, 30, 0).add(2, 28, 1).add(3, 26, 2).add(4, 20, 3).add(5, 17, 4).add(6, 15, 5).add(7, 11, 6).add(8, 7, 7).add(9, 4, 8).add(10, 2, 9);
    }

    public static int totalWeight(List<WeightedLevel> list, float modifier) {
        return list.stream().mapToInt(w -> w.getWeight(modifier)).sum();
    }

    public static int getRandomItem(List<WeightedLevel> list, Random rand, float modifier) {
        int total = ItemLevelLootFunction.totalWeight(list, modifier);
        if (total <= 0) {
            throw new IllegalArgumentException();
        }
        int randWeight = rand.nextInt(total);
        for (WeightedLevel w : list) {
            if ((randWeight -= w.getWeight(modifier)) >= 0) continue;
            return w.level;
        }
        return 1;
    }

    public static JsonArray serialize(List<WeightedLevel> list) {
        list.sort(Comparator.comparingInt(w -> w.level));
        JsonArray arr = new JsonArray();
        list.forEach(w -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("weight", (Number)w.weight);
            obj.addProperty("luck_bonus", (Number)w.bonus);
            obj.addProperty("level", (Number)w.level);
            arr.add((JsonElement)obj);
        });
        return arr;
    }

    public static List<WeightedLevel> deserialize(JsonElement element) {
        ArrayList<WeightedLevel> list = new ArrayList<WeightedLevel>();
        if (!element.isJsonArray()) {
            throw new JsonParseException("Expected a json array for " + String.valueOf(element));
        }
        element.getAsJsonArray().forEach(el -> {
            if (!el.isJsonObject()) {
                throw new JsonParseException("Expected a json object for " + String.valueOf(el));
            }
            JsonObject obj = (JsonObject)el;
            list.add(new WeightedLevel(GsonHelper.m_13824_((JsonObject)obj, (String)"weight", (int)1), GsonHelper.m_13824_((JsonObject)obj, (String)"luck_bonus", (int)0), GsonHelper.m_13824_((JsonObject)obj, (String)"level", (int)1)));
        });
        return list;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLootRegistries.ITEM_LEVEL.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext ctx) {
        int level = 0;
        if (ctx.m_78936_(LootCtxParameters.ITEM_LEVEL_CONTEXT)) {
            level = (Integer)ctx.m_165124_(LootCtxParameters.ITEM_LEVEL_CONTEXT);
        } else if (ctx.m_78936_(LootContextParams.f_81461_) && ctx.m_78936_(LootContextParams.f_81460_)) {
            BlockPos blockPos = new BlockPos((Vec3)ctx.m_165124_(LootContextParams.f_81460_));
            level = FarmlandHandler.get(ctx.m_78952_().m_142572_()).getData(ctx.m_78952_(), blockPos).map(FarmlandData::getCropLevel).orElse(0);
        }
        if (level == 0) {
            level = this.getLevel(ctx);
        }
        return ItemNBT.getLeveledItem(stack, Math.abs(level));
    }

    public int getLevel(LootContext ctx) {
        return ItemLevelLootFunction.getRandomItem(this.levels, ctx.m_78933_(), ctx.m_78945_());
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<WeightedLevel> levels = new ArrayList<WeightedLevel>();

        protected Builder getThis() {
            return this;
        }

        public Builder add(int level, int weight, int bonus) {
            this.levels.add(new WeightedLevel(weight, bonus, level));
            return this;
        }

        public LootItemFunction m_7453_() {
            return new ItemLevelLootFunction(this.m_80699_(), this.levels);
        }
    }

    public record WeightedLevel(int weight, int bonus, int level) {
        public int getWeight(float modifier) {
            return this.weight + (int)((float)this.bonus * modifier);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeightedLevel) {
                return ((WeightedLevel)obj).weight == this.weight;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.weight;
        }

        @Override
        public String toString() {
            return String.format("Level: %d; Weight: %d; Bonus: %d", this.level, this.weight, this.bonus);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ItemLevelLootFunction> {
        public void serialize(JsonObject obj, ItemLevelLootFunction func, JsonSerializationContext context) {
            super.m_6170_(obj, (LootItemConditionalFunction)func, context);
            obj.add("level_weight", (JsonElement)ItemLevelLootFunction.serialize(func.levels));
        }

        public ItemLevelLootFunction deserialize(JsonObject obj, JsonDeserializationContext ctx, LootItemCondition[] conditions) {
            return new ItemLevelLootFunction(conditions, ItemLevelLootFunction.deserialize(obj.get("level_weight")));
        }
    }
}

