/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootingAndLuckLootFunction
extends LootItemConditionalFunction {
    private final NumberProvider baseChance;
    private final NumberProvider lootingBonus;
    private final NumberProvider luckBonus;
    private final int limit;

    private LootingAndLuckLootFunction(LootItemCondition[] conditions, NumberProvider baseChance, NumberProvider luckBonus, NumberProvider lootingBonus, int limit) {
        super(conditions);
        this.baseChance = baseChance;
        this.luckBonus = luckBonus;
        this.lootingBonus = lootingBonus;
        this.limit = limit;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLootRegistries.LUCK_AND_LOOTING.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext ctx) {
        Entity entity = (Entity)ctx.m_78953_(LootContextParams.f_81458_);
        float luck = ctx.m_78945_();
        int looting = 0;
        List<LivingEntity> contributing = LootingAndLuckLootFunction.getContributingEntities(ctx);
        if (entity instanceof LivingEntity) {
            looting = Platform.INSTANCE.getLootingFromCtx(ctx);
        }
        for (LivingEntity other : contributing) {
            looting += Platform.INSTANCE.getLootingFromEntity((Entity)ctx.m_78953_(LootContextParams.f_81455_), (Entity)other, (DamageSource)ctx.m_78953_(LootContextParams.f_81457_));
            if (!other.m_21204_().m_22171_(Attributes.f_22286_)) continue;
            luck += (float)other.m_21133_(Attributes.f_22286_);
        }
        float chance = (this.baseChance.m_142688_(ctx) + this.luckBonus.m_142688_(ctx) * luck) * (1.0f + this.lootingBonus.m_142688_(ctx) * (float)looting);
        if (chance >= 1.0f) {
            int uniform = (int)chance * 2;
            float left = chance - (float)uniform;
            int amount = ctx.m_78933_().nextInt(uniform + 1);
            if (ctx.m_78933_().nextFloat() < left) {
                ++amount;
            }
            if (this.limit > 0) {
                amount = Math.min(this.limit, amount);
            }
            stack.m_41764_(amount);
            return stack;
        }
        if (ctx.m_78933_().nextFloat() < chance) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static List<LivingEntity> getContributingEntities(LootContext ctx) {
        EntityNPCBase npc;
        Entity entity = (Entity)ctx.m_78953_(LootContextParams.f_81458_);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Platform.INSTANCE.getPlayerData(player).map(d -> entity.f_19853_.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), entity.m_142469_().m_82400_(64.0), d.party::isPartyMember)).orElse(List.of());
        }
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (monster.getOwner() != null && Platform.INSTANCE.getPlayerData(monster.getOwner()).map(d -> d.party.isPartyMember((Entity)monster)).orElse(false).booleanValue()) {
                return List.of(monster);
            }
        } else if (entity instanceof EntityNPCBase && (npc = (EntityNPCBase)entity).followEntity() != null && Platform.INSTANCE.getPlayerData(npc.followEntity()).map(d -> d.party.isPartyMember((Entity)npc)).orElse(false).booleanValue()) {
            return List.of(npc);
        }
        return List.of();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<LootingAndLuckLootFunction> {
        public void serialize(JsonObject obj, LootingAndLuckLootFunction func, JsonSerializationContext context) {
            super.m_6170_(obj, (LootItemConditionalFunction)func, context);
            obj.add("baseChance", context.serialize((Object)func.baseChance));
            obj.add("luckBonus", context.serialize((Object)func.luckBonus));
            obj.add("lootingBonus", context.serialize((Object)func.lootingBonus));
            obj.addProperty("limit", (Number)func.limit);
        }

        public LootingAndLuckLootFunction deserialize(JsonObject obj, JsonDeserializationContext ctx, LootItemCondition[] conditions) {
            return new LootingAndLuckLootFunction(conditions, (NumberProvider)GsonHelper.m_13836_((JsonObject)obj, (String)"baseChance", (JsonDeserializationContext)ctx, NumberProvider.class), (NumberProvider)GsonHelper.m_13836_((JsonObject)obj, (String)"luckBonus", (JsonDeserializationContext)ctx, NumberProvider.class), (NumberProvider)GsonHelper.m_13836_((JsonObject)obj, (String)"lootingBonus", (JsonDeserializationContext)ctx, NumberProvider.class), GsonHelper.m_13824_((JsonObject)obj, (String)"limit", (int)0));
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NumberProvider baseChance;
        private NumberProvider lootingBonus = ConstantValue.m_165692_((float)0.0f);
        private NumberProvider luckBonus = ConstantValue.m_165692_((float)0.0f);
        private int limit = 0;

        public Builder(NumberProvider baseChance) {
            this.baseChance = baseChance;
        }

        protected Builder getThis() {
            return this;
        }

        public Builder withLuckBonus(NumberProvider luckBonus) {
            this.luckBonus = luckBonus;
            return this;
        }

        public Builder withLootingBonus(NumberProvider lootingBonus) {
            this.lootingBonus = lootingBonus;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public LootItemFunction m_7453_() {
            return new LootingAndLuckLootFunction(this.m_80699_(), this.baseChance, this.luckBonus, this.lootingBonus, this.limit);
        }
    }
}

