/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import io.github.flemmli97.runecraftory.common.world.family.FamilyEntry;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record NPCRelationCondition(FamilyEntry.Relationship relation) implements LootItemCondition
{
    public static LootItemCondition.Builder of(FamilyEntry.Relationship relation) {
        return () -> new NPCRelationCondition(relation);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootRegistries.INTERACTINGPLAYER.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_, LootCtxParameters.UUID_CONTEXT);
    }

    public boolean test(LootContext ctx) {
        Object object = ctx.m_78953_(LootContextParams.f_81455_);
        if (object instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)object;
            UUID player = (UUID)ctx.m_78953_(LootCtxParameters.UUID_CONTEXT);
            if (player != null) {
                return npc.relationFor(player) == this.relation;
            }
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<NPCRelationCondition> {
        public void serialize(JsonObject object, NPCRelationCondition condition, JsonSerializationContext context) {
            object.addProperty("relation", condition.relation.name());
        }

        public NPCRelationCondition deserialize(JsonObject obj, JsonDeserializationContext context) {
            String type = GsonHelper.m_13851_((JsonObject)obj, (String)"relation", (String)FamilyEntry.Relationship.NONE.toString());
            try {
                return new NPCRelationCondition(FamilyEntry.Relationship.valueOf(type));
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("Unknown relation type '" + type + "'");
            }
        }
    }
}

