/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class SkillLevelCondition
implements LootItemCondition {
    private final EnumSkills skill;
    private final int min;

    public SkillLevelCondition(EnumSkills skills, int required) {
        this.skill = skills;
        this.min = required;
    }

    public static LootItemCondition.Builder get(EnumSkills skill, int val) {
        return () -> new SkillLevelCondition(skill, val);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootRegistries.SKILL_CHECK.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public boolean test(LootContext ctx) {
        int level = 0;
        Object object = ctx.m_78953_(LootContextParams.f_81455_);
        if (object instanceof Player) {
            Player player = (Player)object;
            level = Platform.INSTANCE.getPlayerData(player).map(data -> data.getSkillLevel(this.skill).getLevel()).orElse(0);
        }
        return level >= this.min;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SkillLevelCondition> {
        public void serialize(JsonObject object, SkillLevelCondition condition, JsonSerializationContext context) {
            object.addProperty("skill", condition.skill.name());
            object.addProperty("min_required_level", (Number)condition.min);
        }

        public SkillLevelCondition deserialize(JsonObject obj, JsonDeserializationContext context) {
            String skillString = GsonHelper.m_13906_((JsonObject)obj, (String)"skill");
            try {
                return new SkillLevelCondition(EnumSkills.valueOf(skillString), GsonHelper.m_13824_((JsonObject)obj, (String)"min_required_level", (int)0));
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("Unknown skill '" + skillString + "'");
            }
        }
    }
}

