/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.ModLootRegistries;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record TalkCountCondition(int count) implements LootItemCondition
{
    public static LootItemCondition.Builder of(int count) {
        return () -> new TalkCountCondition(count);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootRegistries.TALKCOUNT.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public boolean test(LootContext ctx) {
        Object object = ctx.m_78953_(LootContextParams.f_81455_);
        if (object instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)object;
            UUID uuid = (UUID)ctx.m_78953_(LootCtxParameters.UUID_CONTEXT);
            if (uuid != null) {
                return npc.talkCount(uuid) >= this.count;
            }
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<TalkCountCondition> {
        public void serialize(JsonObject object, TalkCountCondition condition, JsonSerializationContext context) {
            object.addProperty("count", (Number)condition.count);
        }

        public TalkCountCondition deserialize(JsonObject obj, JsonDeserializationContext context) {
            return new TalkCountCondition(GsonHelper.m_13824_((JsonObject)obj, (String)"count", (int)0));
        }
    }
}

