/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class C2SNPCInteraction
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "c2s_npc_interaction");
    private final int id;
    private final Type type;
    private final String action;

    public C2SNPCInteraction(int entityID, Type type) {
        this(entityID, type, "");
    }

    public C2SNPCInteraction(int entityID, String action) {
        this(entityID, Type.ACTION, action);
    }

    public C2SNPCInteraction(int entityID, Type type, String action) {
        this.id = entityID;
        this.type = type;
        this.action = action == null ? "" : action;
    }

    public static C2SNPCInteraction read(FriendlyByteBuf buf) {
        return new C2SNPCInteraction(buf.readInt(), (Type)buf.m_130066_(Type.class), buf.m_130277_());
    }

    public static void handle(C2SNPCInteraction pkt, ServerPlayer sender) {
        Entity entity;
        if (sender != null && (entity = sender.f_19853_.m_6815_(pkt.id)) instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)entity;
            switch (pkt.type) {
                case TALK: {
                    npc.talkTo(sender);
                    break;
                }
                case FOLLOW: {
                    if (Platform.INSTANCE.getPlayerData((Player)sender).map(d -> !d.party.isPartyMember(entity) && d.party.isPartyFull()).orElse(true).booleanValue()) {
                        sender.m_6352_((Component)new TranslatableComponent("runecraftory.monster.interact.party.full"), Util.f_137441_);
                        return;
                    }
                    if (npc.getEntityToFollowUUID() != null) break;
                    npc.followEntity(sender);
                    break;
                }
                case FOLLOWDISTANCE: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.m_142081_())) break;
                    npc.setBehaviour(EntityNPCBase.Behaviour.FOLLOW_DISTANCE);
                    break;
                }
                case STAY: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.m_142081_())) break;
                    npc.setBehaviour(EntityNPCBase.Behaviour.STAY);
                    break;
                }
                case STOPFOLLOW: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.m_142081_())) break;
                    npc.followEntity(null);
                    break;
                }
                case SHOP: {
                    npc.openShopForPlayer(sender);
                    break;
                }
                case QUEST: {
                    npc.respondToQuest(sender, new ResourceLocation(pkt.action));
                    break;
                }
                case CLOSE: {
                    npc.closedDialogue(sender);
                    break;
                }
                case CLOSE_QUEST: {
                    npc.closedQuestDialogue(sender);
                    break;
                }
                case ACTION: {
                    if (npc.m_6162_()) break;
                    npc.getShop().handleAction(npc, (Player)sender, pkt.action);
                }
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.m_130068_((Enum)this.type);
        buf.m_130070_(this.action);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    public static enum Type {
        TALK("runecraftory.gui.npc.talk", null),
        FOLLOW("runecraftory.gui.npc.follow", EntityNPCBase.Behaviour.FOLLOW),
        FOLLOWDISTANCE("runecraftory.gui.npc.distance", EntityNPCBase.Behaviour.FOLLOW_DISTANCE),
        STAY("runecraftory.gui.npc.stay", EntityNPCBase.Behaviour.STAY),
        STOPFOLLOW("runecraftory.gui.npc.stopFollow", EntityNPCBase.Behaviour.WANDER),
        SHOP("runecraftory.gui.npc.shop", null),
        CLOSE("runecraftory.gui.npc.close", null),
        CLOSE_QUEST("runecraftory.gui.npc.close.quest", null),
        QUEST("runecraftory.gui.quest.button", null),
        ACTION("", null);

        public final String translation;
        @Nullable
        public final EntityNPCBase.Behaviour behaviour;

        private Type(String translation, EntityNPCBase.Behaviour behaviour) {
            this.translation = translation;
            this.behaviour = behaviour;
        }
    }
}

