/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.common.quests.QuestData;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record C2SQuestSelect(ResourceLocation quest, boolean active) implements Packet
{
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "c2s_quest_select");

    public C2SQuestSelect() {
        this(null, false);
    }

    public static C2SQuestSelect read(FriendlyByteBuf buf) {
        return new C2SQuestSelect(buf.readBoolean() ? buf.m_130281_() : null, buf.readBoolean());
    }

    public static void handle(C2SQuestSelect pkt, ServerPlayer sender) {
        if (sender != null) {
            QuestData data = QuestHandler.getData(sender);
            if (pkt.quest() == null) {
                data.setQuestboardQuests(null);
            } else if (pkt.active()) {
                data.reset(pkt.quest());
            } else {
                data.acceptQuest(pkt.quest());
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.quest != null);
        if (this.quest != null) {
            buf.m_130085_(this.quest);
        }
        buf.writeBoolean(this.active);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

