/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class C2SSetMonsterBehaviour
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "c2s_monster_behaviour");
    private final int id;
    private final Type type;

    public C2SSetMonsterBehaviour(int entityID, Type type) {
        this.id = entityID;
        this.type = type;
    }

    public static C2SSetMonsterBehaviour read(FriendlyByteBuf buf) {
        return new C2SSetMonsterBehaviour(buf.readInt(), (Type)buf.m_130066_(Type.class));
    }

    public static void handle(C2SSetMonsterBehaviour pkt, ServerPlayer sender) {
        Entity entity;
        if (sender != null && (entity = sender.f_19853_.m_6815_(pkt.id)) instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (sender.m_142081_().equals(monster.m_142504_())) {
                switch (pkt.type) {
                    case HOME: 
                    case FOLLOW: 
                    case FOLLOW_DISTANCE: 
                    case STAY: 
                    case WANDER: {
                        if (pkt.type == Type.FOLLOW && Platform.INSTANCE.getPlayerData((Player)sender).map(d -> !d.party.isPartyMember(entity) && d.party.isPartyFull()).orElse(true).booleanValue()) {
                            sender.m_6352_((Component)new TranslatableComponent("runecraftory.monster.interact.party.full"), Util.f_137441_);
                            return;
                        }
                        monster.setBehaviour(pkt.type.behaviour);
                        sender.m_6352_((Component)new TranslatableComponent(monster.behaviourState().interactKey, new Object[]{monster.m_5446_()}), Util.f_137441_);
                        break;
                    }
                    case FARM: {
                        monster.setBehaviour(BaseMonster.Behaviour.FARM);
                        sender.m_6352_((Component)new TranslatableComponent(monster.behaviourState().interactKey, new Object[]{monster.m_5446_()}), Util.f_137441_);
                        ModCriteria.COMMAND_FARMING.trigger(sender);
                        break;
                    }
                    case CENTER: 
                    case CENTER_FARM: {
                        Platform.INSTANCE.getPlayerData((Player)sender).ifPresent(data -> {
                            data.entitySelector.selectedEntity = monster;
                            data.entitySelector.poi = monster.m_21534_();
                            data.entitySelector.apply = (player, pos) -> {
                                monster.restrictToBasedOnBehaviour((BlockPos)pos, false);
                                data.entitySelector.poi = monster.m_21534_();
                            };
                        });
                        break;
                    }
                    case HARVESTINV: {
                        Platform.INSTANCE.getPlayerData((Player)sender).ifPresent(data -> {
                            data.entitySelector.selectedEntity = monster;
                            data.entitySelector.poi = monster.getCropInventory();
                            data.entitySelector.apply = (player, pos) -> {
                                if (monster.m_21444_((BlockPos)pos)) {
                                    monster.setCropInventory((BlockPos)pos);
                                    data.entitySelector.poi = monster.getCropInventory();
                                    player.m_6352_((Component)new TranslatableComponent("runecraftory.behaviour.inventory.harvest"), Util.f_137441_);
                                } else {
                                    player.m_6352_((Component)new TranslatableComponent("runecraftory.behaviour.inventory.harvest.invalid"), Util.f_137441_);
                                }
                            };
                        });
                        break;
                    }
                    case SEEDINV: {
                        Platform.INSTANCE.getPlayerData((Player)sender).ifPresent(data -> {
                            data.entitySelector.selectedEntity = monster;
                            data.entitySelector.poi = monster.getSeedInventory();
                            data.entitySelector.apply = (player, pos) -> {
                                if (monster.m_21444_((BlockPos)pos)) {
                                    monster.setSeedInventory((BlockPos)pos);
                                    data.entitySelector.poi = monster.getSeedInventory();
                                    player.m_6352_((Component)new TranslatableComponent("runecraftory.behaviour.inventory.seed"), Util.f_137441_);
                                } else {
                                    player.m_6352_((Component)new TranslatableComponent("runecraftory.behaviour.inventory.seed.invalid"), Util.f_137441_);
                                }
                            };
                        });
                        break;
                    }
                    case RIDE: {
                        if (monster.behaviourState() != BaseMonster.Behaviour.FOLLOW && monster.behaviourState() != BaseMonster.Behaviour.FOLLOW_DISTANCE && monster.behaviourState() != BaseMonster.Behaviour.STAY) break;
                        monster.doStartRide(sender);
                    }
                }
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.m_130068_((Enum)this.type);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    public static enum Type {
        HOME("runecraftory.gui.companion.behaviour.home", BaseMonster.Behaviour.WANDER_HOME),
        FOLLOW("runecraftory.gui.companion.behaviour.follow", BaseMonster.Behaviour.FOLLOW),
        FOLLOW_DISTANCE("runecraftory.gui.companion.behaviour.follow_distance", BaseMonster.Behaviour.FOLLOW_DISTANCE),
        STAY("runecraftory.gui.companion.behaviour.stay", BaseMonster.Behaviour.STAY),
        WANDER("runecraftory.gui.companion.behaviour.wander", BaseMonster.Behaviour.WANDER),
        FARM("runecraftory.gui.companion.behaviour.farm", BaseMonster.Behaviour.FARM),
        HARVESTINV("runecraftory.gui.companion.behaviour.harvest", BaseMonster.Behaviour.FARM),
        SEEDINV("runecraftory.gui.companion.behaviour.seed", BaseMonster.Behaviour.FARM),
        RIDE("runecraftory.gui.companion.behaviour.ride", BaseMonster.Behaviour.FOLLOW),
        CENTER("runecraftory.gui.companion.behaviour.center", BaseMonster.Behaviour.WANDER),
        CENTER_FARM("runecraftory.gui.companion.behaviour.center", BaseMonster.Behaviour.FARM);

        public final String translation;
        public final BaseMonster.Behaviour behaviour;

        private Type(String translation, BaseMonster.Behaviour behaviour) {
            this.translation = translation;
            this.behaviour = behaviour;
        }
    }
}

