/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.common.items.creative.NPCSpawnEgg;
import io.github.flemmli97.runecraftory.common.items.creative.RuneCraftoryEggItem;
import io.github.flemmli97.runecraftory.common.network.Packet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class C2SSpawnEgg
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "c2s_spawn_egg");
    private final InteractionHand hand;
    private final int level;
    private final ResourceLocation npcID;

    public C2SSpawnEgg(InteractionHand hand, int level, @Nullable ResourceLocation npcID) {
        this.hand = hand;
        this.level = level;
        this.npcID = npcID;
    }

    public static C2SSpawnEgg read(FriendlyByteBuf buf) {
        return new C2SSpawnEgg((InteractionHand)buf.m_130066_(InteractionHand.class), buf.readInt(), buf.readBoolean() ? buf.m_130281_() : null);
    }

    public static void handle(C2SSpawnEgg pkt, ServerPlayer sender) {
        ItemStack stack;
        if (sender != null && (stack = sender.m_21120_(pkt.hand)).m_41720_() instanceof RuneCraftoryEggItem) {
            RuneCraftoryEggItem.setMobLevel(stack, pkt.level);
            if (stack.m_41720_() instanceof NPCSpawnEgg) {
                NPCSpawnEgg.setNpcID(stack, pkt.npcID);
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.hand);
        buf.writeInt(this.level);
        buf.writeBoolean(this.npcID != null);
        if (this.npcID != null) {
            buf.m_130085_(this.npcID);
        }
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

