/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.client.BossBarTracker;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.network.Packet;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;

public class S2CBossbarInfoAdd
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "s2c_bossbar_info_add");
    private final UUID id;
    private final UUID musicID;
    private final ResourceLocation type;
    private final SoundEvent sound;

    public S2CBossbarInfoAdd(UUID id, UUID musicID, ResourceLocation type, SoundEvent sound) {
        this.id = id;
        this.musicID = musicID;
        this.type = type;
        this.sound = sound;
    }

    public static S2CBossbarInfoAdd read(FriendlyByteBuf buf) {
        return new S2CBossbarInfoAdd(buf.m_130259_(), buf.m_130259_(), buf.readBoolean() ? buf.m_130281_() : null, buf.readBoolean() ? (SoundEvent)Registry.f_122821_.m_7745_(buf.m_130281_()) : null);
    }

    public static void handle(S2CBossbarInfoAdd pkt) {
        Player player = ClientHandlers.getPlayer();
        if (player == null) {
            return;
        }
        BossBarTracker.addActiveBossbar(pkt.id, pkt.musicID, pkt.type, pkt.sound);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        buf.m_130077_(this.musicID);
        buf.writeBoolean(this.type != null);
        if (this.type != null) {
            buf.m_130085_(this.type);
        }
        buf.writeBoolean(this.sound != null);
        if (this.sound != null) {
            buf.m_130085_(Registry.f_122821_.m_7981_((Object)this.sound));
        }
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

