/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.network.Packet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class S2CCraftingRecipes
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "s2c_crafting_recipes_container");
    private final List<Pair<Integer, ItemStack>> data;
    private final int clientRecipeIndex;

    public S2CCraftingRecipes(List<Pair<Integer, ItemStack>> data, int clientRecipeIndex) {
        this.data = data;
        this.clientRecipeIndex = clientRecipeIndex;
    }

    public static S2CCraftingRecipes read(FriendlyByteBuf buf) {
        ArrayList<Pair<Integer, ItemStack>> list = new ArrayList<Pair<Integer, ItemStack>>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            list.add((Pair<Integer, ItemStack>)Pair.of((Object)buf.readInt(), (Object)buf.m_130267_()));
        }
        return new S2CCraftingRecipes(list, buf.readInt());
    }

    public static void handle(S2CCraftingRecipes pkt) {
        Player player = ClientHandlers.getPlayer();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ContainerCrafting) {
            ContainerCrafting crafting = (ContainerCrafting)abstractContainerMenu;
            crafting.setMatchingRecipesClient(pkt.data);
        }
        ClientHandlers.updateCurrentRecipeIndex(pkt.clientRecipeIndex);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.data.size());
        this.data.forEach(p -> {
            buf.writeInt(((Integer)p.getFirst()).intValue());
            buf.m_130055_((ItemStack)p.getSecond());
        });
        buf.writeInt(this.clientRecipeIndex);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

