/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record S2CEntityDataSync(int entityID, Type type, boolean flag) implements Packet
{
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "s2c_entity_data_sync");

    public static S2CEntityDataSync read(FriendlyByteBuf buf) {
        return new S2CEntityDataSync(buf.readInt(), (Type)buf.m_130066_(Type.class), buf.readBoolean());
    }

    public static void handle(S2CEntityDataSync pkt) {
        Player player = ClientHandlers.getPlayer();
        if (player == null) {
            return;
        }
        Entity e = player.f_19853_.m_6815_(pkt.entityID);
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            Platform.INSTANCE.getEntityData(living).ifPresent(data -> {
                switch (pkt.type) {
                    case POISON: {
                        data.setPoison(living, pkt.flag);
                        break;
                    }
                    case SLEEP: {
                        data.setSleeping(living, pkt.flag);
                        break;
                    }
                    case PARALYSIS: {
                        data.setParalysis(living, pkt.flag);
                        break;
                    }
                    case COLD: {
                        data.setCold(living, pkt.flag);
                        break;
                    }
                    case INVIS: {
                        data.setInvis(living, pkt.flag);
                        break;
                    }
                    case ORTHOVIEW: {
                        data.setOrthoView(living, pkt.flag);
                        break;
                    }
                    case STUN: {
                        data.setStunned(living, pkt.flag);
                    }
                }
            });
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130068_((Enum)this.type);
        buf.writeBoolean(this.flag);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    public static enum Type {
        POISON,
        SLEEP,
        PARALYSIS,
        STUN,
        COLD,
        FATIGUE,
        SEAL,
        INVIS,
        ORTHOVIEW;

    }
}

