/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.network.Packet;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record S2CNpcDialogue(int entity, ConversationContext convCtx, String conversationID, Component component, Map<String, Component> data, List<Component> actions) implements Packet
{
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "s2c_npc_dialogue");

    public static S2CNpcDialogue read(FriendlyByteBuf buf) {
        return new S2CNpcDialogue(buf.readInt(), buf.readBoolean() ? ConversationContext.get(buf.m_130281_()) : null, buf.readBoolean() ? buf.m_130277_() : null, buf.m_130238_(), buf.m_178368_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130238_), buf.m_178366_(FriendlyByteBuf::m_130238_));
    }

    public static void handle(S2CNpcDialogue pkt) {
        Player player = ClientHandlers.getPlayer();
        if (player == null) {
            return;
        }
        Entity entity = player.f_19853_.m_6815_(pkt.entity);
        if (entity instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)entity;
            ClientHandlers.updateNPCDialogue(npc, pkt.convCtx, pkt.conversationID, pkt.component, pkt.data, pkt.actions);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entity);
        buf.writeBoolean(this.convCtx != null);
        if (this.convCtx != null) {
            buf.m_130085_(this.convCtx.key());
        }
        buf.writeBoolean(this.conversationID != null);
        if (this.conversationID != null) {
            buf.m_130070_(this.conversationID);
        }
        buf.m_130083_(this.component);
        buf.m_178355_(this.data, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130083_);
        buf.m_178352_(this.actions, FriendlyByteBuf::m_130083_);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

