/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.world.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class S2COpenNPCGui
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "s2c_npc_gui");
    private final int entityID;
    private final ShopState isShopOpen;
    private final int followState;
    private final Map<String, List<Component>> actions;
    private final ResourceLocation quest;
    private final SyncedFamilyData family;

    private S2COpenNPCGui(int id, ShopState isShopOpen, int followState, Map<String, List<Component>> actions, ResourceLocation quest, SyncedFamilyData family) {
        this.entityID = id;
        this.isShopOpen = isShopOpen;
        this.followState = followState;
        this.actions = actions;
        this.quest = quest;
        this.family = family;
    }

    public S2COpenNPCGui(EntityNPCBase entity, ServerPlayer player) {
        this.entityID = entity.m_142049_();
        this.isShopOpen = entity.canTrade();
        this.actions = entity.getShop().actions(entity, player);
        this.quest = QuestHandler.questForExists(player, entity);
        this.followState = entity.getEntityToFollowUUID() == null ? (Platform.INSTANCE.getPlayerData((Player)player).map(d -> d.party.isPartyFull()).orElse(true) != false ? 2 : 0) : (entity.getEntityToFollowUUID().equals(player.m_142081_()) ? 1 : 2);
        this.family = entity.getFamily().forSyncing(entity, player);
    }

    public static S2COpenNPCGui read(FriendlyByteBuf buf) {
        return new S2COpenNPCGui(buf.readInt(), (ShopState)buf.m_130066_(ShopState.class), buf.readInt(), buf.m_178374_(LinkedHashMap::new, FriendlyByteBuf::m_130277_, b -> b.m_178366_(FriendlyByteBuf::m_130238_)), !buf.readBoolean() ? null : buf.m_130281_(), new SyncedFamilyData(buf));
    }

    public static void handle(S2COpenNPCGui pkt) {
        ClientHandlers.openNPCChat(pkt.entityID, pkt.isShopOpen, pkt.family, pkt.followState, pkt.actions, pkt.quest);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130068_((Enum)this.isShopOpen);
        buf.writeInt(this.followState);
        buf.m_178355_(this.actions, FriendlyByteBuf::m_130070_, (buf1, components) -> buf1.m_178352_((Collection)components, FriendlyByteBuf::m_130083_));
        buf.writeBoolean(this.quest != null);
        if (this.quest != null) {
            buf.m_130085_(this.quest);
        }
        this.family.toPacket(buf);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

