/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.ShakeHandler;
import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record S2CScreenShake(int shakeDuration, float strength) implements Packet
{
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "s2c_screen_shake");

    public static void sendAround(Entity entity, double range, int duration, float strength) {
        S2CScreenShake.sendAround(entity.f_19853_, entity.m_20182_(), range, duration, strength);
    }

    public static void sendAround(Level level, Vec3 pos, double range, int duration, float strength) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB area = new AABB(pos.m_7096_() - 0.5, pos.m_7098_() - 0.5, pos.m_7094_() + 0.5, pos.m_7096_() + 0.5, pos.m_7098_() + 0.5, pos.m_7094_() + 0.5).m_82400_(range);
            for (ServerPlayer player : serverLevel.m_6907_()) {
                if (!area.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
                Platform.INSTANCE.sendToClient(new S2CScreenShake(duration, strength), player);
            }
        }
    }

    public static S2CScreenShake read(FriendlyByteBuf buf) {
        return new S2CScreenShake(buf.readInt(), buf.readFloat());
    }

    public static void handle(S2CScreenShake pkt) {
        Player player = ClientHandlers.getPlayer();
        if (player == null) {
            return;
        }
        ShakeHandler.shakeScreen(pkt.shakeDuration, pkt.strength);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.shakeDuration);
        buf.writeFloat(this.strength);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

