/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<BlockStateParticleData> DESERIALIZER = new ParticleOptions.Deserializer<BlockStateParticleData>(){

        public BlockStateParticleData fromCommand(ParticleType<BlockStateParticleData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float yaw = reader.readFloat();
            reader.expect(' ');
            float pitch = reader.readFloat();
            reader.expect(' ');
            int duration = reader.readInt();
            reader.expect(' ');
            return new BlockStateParticleData(particleType, new BlockStateParser(reader, false).m_116806_(false).m_116808_(), yaw, pitch, duration);
        }

        public BlockStateParticleData fromNetwork(ParticleType<BlockStateParticleData> particleType, FriendlyByteBuf buffer) {
            return new BlockStateParticleData(particleType, (BlockState)Block.f_49791_.m_7942_(buffer.m_130242_()), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
        }
    };
    private final ParticleType<? extends BlockStateParticleData> type;
    private final BlockState state;
    private final float yaw;
    private final float pitch;
    private final int duration;

    public static Codec<BlockStateParticleData> codec(ParticleType<BlockStateParticleData> type) {
        return BlockState.f_61039_.xmap(blockState -> new BlockStateParticleData((ParticleType<? extends BlockStateParticleData>)type, (BlockState)blockState), BlockParticleOptionEx -> BlockParticleOptionEx.state);
    }

    public BlockStateParticleData(ParticleType<? extends BlockStateParticleData> type, BlockState state) {
        this(type, state, 0.0f, 0.0f, 40);
    }

    public BlockStateParticleData(ParticleType<? extends BlockStateParticleData> type, BlockState state, float yaw, float pitch, int duration) {
        this.type = type;
        this.state = state;
        this.yaw = yaw;
        this.pitch = pitch;
        this.duration = duration;
    }

    public BlockState getState() {
        return this.state;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getDuration() {
        return this.duration;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130130_(Block.f_49791_.m_7447_((Object)this.state));
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
        buffer.writeInt(this.duration);
    }

    public String m_5942_() {
        return String.valueOf(Registry.f_122829_.m_7981_(this.m_6012_()));
    }

    public ParticleType<? extends BlockStateParticleData> m_6012_() {
        return this.type;
    }
}

