/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class DurationalParticleData
extends ColoredParticleData {
    public static final ParticleOptions.Deserializer<DurationalParticleData> DESERIALIZER = new ParticleOptions.Deserializer<DurationalParticleData>(){

        public DurationalParticleData fromCommand(ParticleType<DurationalParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float a = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int duration = reader.readInt();
            return new DurationalParticleData(r, g, b, a, scale, duration);
        }

        public DurationalParticleData fromNetwork(ParticleType<DurationalParticleData> type, FriendlyByteBuf buffer) {
            return new DurationalParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readInt());
        }
    };
    private final int duration;
    private final int entityAnchor;

    public DurationalParticleData(float red, float green, float blue, float alpha, float scale, int duration) {
        this(red, green, blue, alpha, scale, duration, -1);
    }

    public DurationalParticleData(float red, float green, float blue, float alpha, float scale, int duration, int entityAnchor) {
        super((ParticleType)ModParticles.DURATIONAL_PARTICLE.get(), red, green, blue, alpha, scale);
        this.duration = duration;
        this.entityAnchor = entityAnchor;
    }

    public static Codec<DurationalParticleData> codec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ColoredParticleData::getRed), (App)Codec.FLOAT.fieldOf("g").forGetter(ColoredParticleData::getGreen), (App)Codec.FLOAT.fieldOf("b").forGetter(ColoredParticleData::getBlue), (App)Codec.FLOAT.fieldOf("alpha").forGetter(ColoredParticleData::getAlpha), (App)Codec.FLOAT.fieldOf("scale").forGetter(ColoredParticleData::getScale), (App)Codec.INT.fieldOf("duration").forGetter(DurationalParticleData::getDuration), (App)Codec.INT.fieldOf("entity_anchor").forGetter(DurationalParticleData::getEntityAnchor)).apply((Applicative)builder, DurationalParticleData::new));
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        super.m_7711_(buffer);
        buffer.writeInt(this.getDuration());
        buffer.writeInt(this.getEntityAnchor());
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEntityAnchor() {
        return this.entityAnchor;
    }
}

