/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.particles;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;

public class SkelefangParticleData
implements ParticleOptions {
    private static final Random RANDOM = new Random();
    public static final ParticleOptions.Deserializer<SkelefangParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SkelefangParticleData>(){

        public SkelefangParticleData fromCommand(ParticleType<SkelefangParticleData> type, StringReader reader) throws CommandSyntaxException {
            SkelefangBoneType boneType;
            reader.expect(' ');
            String bone = reader.readString();
            try {
                boneType = SkelefangBoneType.valueOf(bone);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)new TextComponent("No such bonetype " + bone)).create();
            }
            reader.expect(' ');
            float initX = reader.readFloat();
            reader.expect(' ');
            float initY = reader.readFloat();
            reader.expect(' ');
            float rotX = reader.readFloat();
            reader.expect(' ');
            float rotY = reader.readFloat();
            return new SkelefangParticleData(boneType, initX, initY, rotX, rotY);
        }

        public SkelefangParticleData fromNetwork(ParticleType<SkelefangParticleData> type, FriendlyByteBuf buffer) {
            return new SkelefangParticleData((SkelefangBoneType)buffer.m_130066_(SkelefangBoneType.class), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readBoolean());
        }
    };
    private final SkelefangBoneType boneType;
    private final float initialRotX;
    private final float initialRotY;
    private final float pitchSpin;
    private final float yawSpin;
    private final int maxTime;
    private final boolean gravity;

    public SkelefangParticleData(SkelefangBoneType boneType, float initialRotX, float initialRotY, float pitchSpin, float yawSpin) {
        this(boneType, initialRotX, initialRotY, pitchSpin, yawSpin, (int)(RANDOM.nextFloat() * 10.0f + 15.0f), true);
    }

    public SkelefangParticleData(SkelefangBoneType boneType, float initialRotX, float initialRotY, float pitchSpin, float yawSpin, int maxTime, boolean gravity) {
        this.boneType = boneType;
        this.initialRotX = initialRotX;
        this.initialRotY = initialRotY;
        this.pitchSpin = pitchSpin;
        this.yawSpin = yawSpin;
        this.maxTime = maxTime;
        this.gravity = gravity;
    }

    public static Codec<SkelefangParticleData> codec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.stringEnumCodec(SkelefangBoneType.class, (Enum)SkelefangBoneType.GENERIC).fieldOf("bone").forGetter(SkelefangParticleData::getBoneType), (App)Codec.FLOAT.fieldOf("init_x").forGetter(SkelefangParticleData::getInitialRotX), (App)Codec.FLOAT.fieldOf("init_y").forGetter(SkelefangParticleData::getInitialRotY), (App)Codec.FLOAT.fieldOf("rot_x").forGetter(SkelefangParticleData::getPitchSpin), (App)Codec.FLOAT.fieldOf("rot_y").forGetter(SkelefangParticleData::getYawSpin), (App)Codec.INT.fieldOf("max_ticks").forGetter(SkelefangParticleData::getMaxTime), (App)Codec.BOOL.fieldOf("gravity").forGetter(SkelefangParticleData::hasGravity)).apply((Applicative)builder, (bone, initX, initY, rotX, rotY, maxTick, gravity) -> new SkelefangParticleData((SkelefangBoneType)((Object)((Object)bone)), initX.floatValue(), initY.floatValue(), rotX.floatValue(), rotX.floatValue(), (int)maxTick, (boolean)gravity)));
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.SKELEFANG_BONES.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.getBoneType());
        buffer.writeFloat(this.getInitialRotX());
        buffer.writeFloat(this.getInitialRotY());
        buffer.writeFloat(this.getPitchSpin());
        buffer.writeFloat(this.getYawSpin());
        buffer.writeInt(this.getMaxTime());
        buffer.writeBoolean(this.hasGravity());
    }

    public String m_5942_() {
        return Registry.f_122829_.m_7981_(this.m_6012_()).toString();
    }

    public SkelefangBoneType getBoneType() {
        return this.boneType;
    }

    public float getInitialRotX() {
        return this.initialRotX;
    }

    public float getInitialRotY() {
        return this.initialRotY;
    }

    public float getPitchSpin() {
        return this.pitchSpin;
    }

    public float getYawSpin() {
        return this.yawSpin;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public boolean hasGravity() {
        return this.gravity;
    }

    public static enum SkelefangBoneType {
        HEAD,
        NECK,
        FRONT,
        FRONT_RIBS,
        LEFT_LEG,
        RIGHT_LEG,
        BACK,
        BACK_RIBS,
        TAIL,
        TAIL_BASE,
        GENERIC,
        GENERIC2;

    }
}

