/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.network.S2CSimpleToast;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.quests.tasks.NPCTalkTask;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.datapack.QuestsManager;
import io.github.flemmli97.simplequests_api.impls.progression.EntityTracker;
import io.github.flemmli97.simplequests_api.impls.quests.Quest;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.ProgressionTrackerKey;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.QuestState;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestData
implements PlayerQuestData {
    public static final DateTimeFormatter TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final ServerPlayer player;
    private final List<QuestProgress> currentQuests = new ArrayList<QuestProgress>();
    private final List<QuestProgress> tickables = new ArrayList<QuestProgress>();
    private Map<ResourceLocation, QuestBase> questBoardContent;
    private final Set<ResourceLocation> unlockTracker = new HashSet<ResourceLocation>();
    private LocalDateTime questTrackerTime = LocalDateTime.now();
    private long dailySeed;
    private final Random questRandom = new Random();
    private int finishedQuestDay;
    private final Map<ResourceLocation, Integer> finishedQuestsTracker = new HashMap<ResourceLocation, Integer>();
    private int interactionCooldown;

    public QuestData(ServerPlayer player) {
        this.player = player;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public List<QuestProgress> getCurrentQuest() {
        return this.currentQuests;
    }

    public boolean acceptQuest(ResourceLocation id) {
        QuestBase quest = this.questBoardContent == null ? null : this.questBoardContent.get(id);
        return this.acceptQuest(quest);
    }

    public boolean acceptQuest(QuestBase quest) {
        AcceptType type = this.canAcceptQuest(quest, false);
        if (type != AcceptType.ACCEPT) {
            this.player.m_6352_((Component)new TranslatableComponent(type.langKey()).m_130940_(ChatFormatting.DARK_RED), Util.f_137441_);
            return false;
        }
        this.currentQuests.add(new QuestProgress(quest, (PlayerQuestData)this, 0));
        this.player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12509_, this.player.m_5720_(), this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), 1.0f, 1.2f));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public AcceptType canAcceptQuest(QuestBase quest, boolean ignoreMiss) {
        if (!(ignoreMiss || this.questBoardContent != null && this.questBoardContent.containsKey(quest.id))) {
            return AcceptType.MISSING;
        }
        if (quest instanceof NPCQuest && !WorldHandler.get((MinecraftServer)this.player.m_20194_()).npcHandler.doesNPCExist((npcQuest = (NPCQuest)quest).getNpcUuid())) {
            return AcceptType.NONPC;
        }
        if (!quest.isUnlocked(this.player) || !quest.neededParentQuests.isEmpty() && !this.unlockTracker.containsAll(quest.neededParentQuests)) {
            return AcceptType.REQUIREMENTS;
        }
        if (!(quest instanceof NPCQuest)) ** GOTO lbl-1000
        npcQuest = (NPCQuest)quest;
        if (npcQuest.global) {
            v0 = npcQuest.getOriginID();
        } else lbl-1000:
        // 2 sources

        {
            v0 = id = quest.id;
        }
        if (this.finishedQuestDay > 3 || quest.repeatDelay < 0 && this.getTimesCompleted(id) > 0) {
            return AcceptType.LIMIT;
        }
        return AcceptType.ACCEPT;
    }

    public Map<ResourceLocation, QuestState> submit(@Nullable EntityNPCBase npc) {
        if (this.currentQuests.isEmpty()) {
            return Map.of();
        }
        HashMap<ResourceLocation, QuestState> completion = new HashMap<ResourceLocation, QuestState>();
        ArrayList<QuestProgress> completed = new ArrayList<QuestProgress>();
        for (QuestProgress prog : this.currentQuests) {
            ArrayList tasks = new ArrayList();
            switch (prog.submit((PlayerQuestData)this, npc == null ? "runecraftory_quest_board_trigger" : npc.m_142081_().toString(), tasks::add)) {
                case COMPLETE: {
                    this.completeQuest(prog);
                    completed.add(prog);
                    completion.put(prog.getQuest().id, QuestState.COMPLETE);
                    break;
                }
                case PARTIAL_COMPLETE: {
                    completion.put(prog.getQuest().id, QuestState.PARTIAL_COMPLETE);
                    break;
                }
                case PARTIAL: {
                    this.player.f_19853_.m_6263_(null, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), SoundEvents.f_12509_, this.player.m_5720_(), 1.5f, 1.0f);
                    tasks.forEach(t -> Platform.INSTANCE.sendToClient(new S2CSimpleToast((Component)prog.getName(this.player).m_130940_(ChatFormatting.DARK_PURPLE), (Component)t.translation(this.player).m_130940_(ChatFormatting.GOLD)), this.player));
                    break;
                }
                case NOTHING: {
                    this.player.f_19853_.m_6263_(null, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), SoundEvents.f_12507_, this.player.m_5720_(), 1.5f, 1.0f);
                }
            }
        }
        this.currentQuests.removeAll(completed);
        return completion;
    }

    public Random getRandom(@Nullable ResourceLocation quest) {
        this.questRandom.setSeed(this.dailySeed);
        return this.questRandom;
    }

    public void addTickableProgress(QuestProgress progress) {
        if (!this.tickables.contains(progress)) {
            this.tickables.add(progress);
        }
    }

    public void removeTickableQuestProgress(QuestProgress progress) {
        this.tickables.remove(progress);
    }

    public int getTimesCompleted(ResourceLocation quest) {
        return this.finishedQuestsTracker.getOrDefault(quest, 0);
    }

    public <V, T extends ResolvedQuestTask> Map<ResourceLocation, QuestState> trigger(ProgressionTrackerKey<V, T> key, V with) {
        return this.trigger(key, with, "");
    }

    public <V, T extends ResolvedQuestTask> Map<ResourceLocation, QuestState> trigger(ProgressionTrackerKey<V, T> key, V with, @NotNull String trigger) {
        if (key.equals((Object)EntityTracker.KEY)) {
            if (this.interactionCooldown > 0) {
                return Map.of();
            }
            this.interactionCooldown = 2;
        }
        ArrayList completed = new ArrayList();
        HashMap<ResourceLocation, QuestState> completion = new HashMap<ResourceLocation, QuestState>();
        this.currentQuests.forEach(prog -> {
            Set fulfilled = prog.tryFullFill(this.player, key, with);
            QuestState state = prog.tryComplete((PlayerQuestData)this, "");
            if (state == QuestState.NO && !fulfilled.isEmpty()) {
                fulfilled.forEach(p -> {
                    if (!(p.getSecond() instanceof NPCTalkTask.NPCTalkResolved)) {
                        Platform.INSTANCE.sendToClient(new S2CSimpleToast((Component)prog.getName(this.player).m_130940_(ChatFormatting.DARK_PURPLE), (Component)((ResolvedQuestTask)p.getSecond()).translation(this.player).m_130940_(ChatFormatting.GOLD)), this.player);
                    }
                });
            }
            if (state == QuestState.COMPLETE) {
                this.completeQuest((QuestProgress)prog);
                completed.add(prog);
                completion.put(prog.getQuest().id, QuestState.COMPLETE);
            } else if (state == QuestState.PARTIAL_COMPLETE) {
                completion.put(prog.getQuest().id, QuestState.PARTIAL_COMPLETE);
            }
        });
        this.currentQuests.removeAll(completed);
        return completion;
    }

    private void completeQuest(QuestProgress prog) {
        prog.getQuest().onComplete(this.player);
        prog.getCompletionID().forEach(id -> {
            this.unlockTracker.add((ResourceLocation)id);
            this.finishedQuestsTracker.compute((ResourceLocation)id, (key, i) -> {
                int n;
                if (i == null) {
                    n = 1;
                } else {
                    i = i + 1;
                    n = i;
                }
                return n;
            });
        });
        QuestBase questBase = prog.getQuest();
        if (questBase instanceof NPCQuest) {
            NPCQuest npcQuest = (NPCQuest)questBase;
            if (npcQuest.global) {
                this.unlockTracker.add(npcQuest.getOriginID());
                this.finishedQuestsTracker.compute(npcQuest.getOriginID(), (key, i) -> {
                    int n;
                    if (i == null) {
                        n = 1;
                    } else {
                        i = i + 1;
                        n = i;
                    }
                    return n;
                });
            }
        }
        ++this.finishedQuestDay;
        this.player.f_19853_.m_6263_(null, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), SoundEvents.f_12275_, this.player.m_5720_(), 1.5f, 1.0f);
        if (!prog.getQuest().neededParentQuests.isEmpty() && prog.getQuest().redoParent) {
            prog.getQuest().neededParentQuests.forEach(res -> {
                Quest quest = QuestsManager.instance().getActualQuest(res, null);
                if (quest != null) {
                    this.unlockTracker.remove(quest.id);
                }
            });
        }
    }

    public void tickTickableQuests() {
        this.tickables.removeIf(prog -> {
            Pair fulfilled = prog.tickProgress((PlayerQuestData)this);
            if (!((Set)fulfilled.getSecond()).isEmpty()) {
                ((Set)fulfilled.getSecond()).forEach(p -> Platform.INSTANCE.sendToClient(new S2CSimpleToast((Component)prog.getName(this.player).m_130940_(ChatFormatting.DARK_PURPLE), (Component)p.translation(this.player).m_130940_(ChatFormatting.GOLD)), this.player));
            }
            return (Boolean)fulfilled.getFirst();
        });
    }

    public void tick() {
        --this.interactionCooldown;
        this.tickTickableQuests();
        LocalDateTime now = LocalDateTime.now();
        if (this.questTrackerTime == null || this.questTrackerTime.getDayOfYear() != now.getDayOfYear()) {
            this.dailySeed = this.player.m_21187_().nextLong();
            this.questTrackerTime = now;
            this.finishedQuestDay = 0;
        }
    }

    public void reset(ResourceLocation res) {
        if (this.currentQuests.isEmpty()) {
            return;
        }
        QuestProgress prog = null;
        for (QuestProgress p : this.currentQuests) {
            if (!p.getQuest().id.equals((Object)res)) continue;
            prog = p;
            break;
        }
        if (prog == null) {
            return;
        }
        this.currentQuests.remove(prog);
        this.removeTickableQuestProgress(prog);
        prog.getQuest().onReset(this.player);
    }

    public void clone(QuestData other) {
        this.currentQuests.clear();
        this.currentQuests.addAll(other.currentQuests);
        this.tickables.clear();
        this.tickables.addAll(other.tickables);
        this.unlockTracker.clear();
        this.unlockTracker.addAll(other.unlockTracker);
        this.questTrackerTime = other.questTrackerTime;
        this.dailySeed = other.dailySeed;
        this.finishedQuestDay = other.finishedQuestDay;
        this.finishedQuestsTracker.clear();
        this.finishedQuestsTracker.putAll(other.finishedQuestsTracker);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag quests = new ListTag();
        this.currentQuests.forEach(prog -> quests.add((Object)prog.save()));
        tag.m_128365_("ActiveQuests", (Tag)quests);
        ListTag unlocked = new ListTag();
        this.unlockTracker.forEach(res -> unlocked.add((Object)StringTag.m_129297_((String)res.toString())));
        tag.m_128365_("UnlockedQuests", (Tag)unlocked);
        if (this.questTrackerTime != null) {
            tag.m_128359_("TimeTracker", this.questTrackerTime.format(TIME));
        }
        tag.m_128356_("DailySeed", this.dailySeed);
        tag.m_128405_("DailyDone", this.finishedQuestDay);
        CompoundTag total = new CompoundTag();
        this.finishedQuestsTracker.forEach((res, amount) -> total.m_128405_(res.toString(), amount.intValue()));
        tag.m_128365_("FinishedQuestTracker", (Tag)total);
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("ActiveQuests")) {
            ListTag quests = tag.m_128437_("ActiveQuests", 10);
            quests.forEach(q -> {
                try {
                    QuestProgress prog = new QuestProgress((CompoundTag)q, (PlayerQuestData)this);
                    if (prog.getQuest() != null) {
                        this.currentQuests.add(prog);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        ListTag unlocked = tag.m_128437_("UnlockedQuests", 8);
        unlocked.forEach(t -> this.unlockTracker.add(new ResourceLocation(t.m_7916_())));
        if (tag.m_128441_("TimeTracker")) {
            this.questTrackerTime = LocalDateTime.parse(tag.m_128461_("TimeTracker"), TIME);
        }
        this.dailySeed = tag.m_128454_("DailySeed");
        this.finishedQuestDay = tag.m_128451_("DailyDone");
        CompoundTag total = tag.m_128469_("FinishedQuestTracker");
        total.m_128431_().forEach(key -> this.finishedQuestsTracker.put(new ResourceLocation(key), total.m_128451_(key)));
    }

    public void setQuestboardQuests(Map<ResourceLocation, QuestBase> quest) {
        this.questBoardContent = quest;
    }

    public boolean isActive(ResourceLocation key) {
        return this.currentQuests.stream().anyMatch(p -> p.getQuest().id.equals((Object)key));
    }

    public void resetAll() {
        this.currentQuests.forEach(p -> p.getQuest().onReset(this.player));
        this.currentQuests.clear();
        this.tickables.clear();
        this.questBoardContent = null;
        this.unlockTracker.clear();
        this.finishedQuestsTracker.clear();
        this.finishedQuestDay = 0;
    }

    public static enum AcceptType {
        MISSING("runecraftory.quests.accept_type.missing"),
        REQUIREMENTS("runecraftory.quests.accept_type.requirements"),
        ACCEPT("runecraftory.quests.accept_type.accept"),
        LIMIT("runecraftory.quests.accept_type.limit"),
        NONPC("runecraftory.quest.npc.none");

        final String lang;

        private AcceptType(String id) {
            this.lang = id;
        }

        public String langKey() {
            return this.lang;
        }
    }
}

