/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.progress;

import io.github.flemmli97.runecraftory.common.quests.tasks.ShippingTask;
import io.github.flemmli97.simplequests_api.impls.progression.ProgressionTrackerBase;
import io.github.flemmli97.simplequests_api.player.ProgressionTrackerKey;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ShippingTracker
extends ProgressionTrackerBase<ItemStack, ShippingTask.SkillLevelTaskResolved> {
    public static final String TAMING_PROGRESS = String.valueOf(ShippingTask.ID) + ".progress";
    public static final ProgressionTrackerKey<ItemStack, ShippingTask.SkillLevelTaskResolved> KEY = new ProgressionTrackerKey("runecraftory", "shipping_tracker", ShippingTask.ID);
    private int amount = 0;

    public ShippingTracker(ShippingTask.SkillLevelTaskResolved questEntry) {
        super((ResolvedQuestTask)questEntry);
    }

    public boolean progress(ServerPlayer player, QuestProgress prog, ItemStack with) {
        if (((ItemPredicate)((ShippingTask.SkillLevelTaskResolved)this.questEntry()).item().value()).m_45049_(with)) {
            this.amount += with.m_41613_();
            return this.amount >= ((ShippingTask.SkillLevelTaskResolved)this.questEntry()).amount();
        }
        return false;
    }

    public MutableComponent formattedProgress(ServerPlayer player, QuestProgress progress) {
        float perc = (float)this.amount / (float)((ShippingTask.SkillLevelTaskResolved)this.questEntry()).amount();
        return new TranslatableComponent(TAMING_PROGRESS, new Object[]{this.amount, ((ShippingTask.SkillLevelTaskResolved)this.questEntry()).amount()}).m_130940_(ProgressionTrackerBase.of((float)perc));
    }

    public Tag save() {
        return IntTag.m_128679_((int)this.amount);
    }

    public void load(Tag tag) {
        try {
            this.amount = ((NumericTag)tag).m_7047_();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

