/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LevelTask
implements QuestTask<LevelTaskResolved> {
    public static final QuestEntryKey<LevelTask> ID = new QuestEntryKey(new ResourceLocation("runecraftory", "level"));
    public static final Codec<LevelTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("level").forGetter(d -> d.range)).apply((Applicative)instance, LevelTask::new));
    private final String description;
    private final NumberProvider range;

    public LevelTask(String description, NumberProvider range) {
        this.description = description;
        this.range = range;
        if (this.description.isEmpty() && !(this.range instanceof ConstantValue)) {
            throw new IllegalStateException("Description is required");
        }
    }

    public MutableComponent translation(ServerPlayer player) {
        if (this.description.isEmpty() && this.range instanceof ConstantValue) {
            return new TranslatableComponent(this.getId().toString(), new Object[]{this.range.m_142683_(null)});
        }
        return new TranslatableComponent(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public LevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        LootContext ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (ResourceLocation)base.id);
        return new LevelTaskResolved(this.range.m_142683_(ctx));
    }

    public record LevelTaskResolved(int level) implements ResolvedQuestTask
    {
        public static final Codec<LevelTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, LevelTaskResolved::new));

        public boolean submit(ServerPlayer player) {
            return Platform.INSTANCE.getPlayerData((Player)player).map(d -> d.getPlayerLevel().getLevel() >= this.level).orElse(false);
        }

        public QuestEntryKey<LevelTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            return new TranslatableComponent(this.getId().toString(), new Object[]{this.level});
        }
    }
}

