/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.util.JsonCodecs;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class NPCTalkTask
implements QuestTask<NPCTalkResolved> {
    public static final QuestEntryKey<NPCTalkTask> ID = new QuestEntryKey(new ResourceLocation("runecraftory", "npc_talk"));
    public static final Codec<NPCTalkTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("target_npc_id").forGetter(d -> Optional.ofNullable(d.targetNPCId)), (App)JsonCodecs.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> d.predicate == EntityPredicate.f_36550_ ? Optional.empty() : Optional.of(d.predicate))).apply((Applicative)instance, (npcId, predicate) -> new NPCTalkTask(npcId.orElse(null), predicate.orElse(null))));
    private final ResourceLocation targetNPCId;
    private final EntityPredicate predicate;

    public NPCTalkTask(ResourceLocation generic) {
        this(generic, EntityPredicate.f_36550_);
    }

    protected NPCTalkTask(ResourceLocation generic, EntityPredicate predicate) {
        this.targetNPCId = generic;
        this.predicate = predicate;
    }

    public QuestEntryKey<NPCTalkTask> getId() {
        return ID;
    }

    public MutableComponent translation(ServerPlayer player) {
        return new TranslatableComponent(this.getId().toString() + ".not_resolved");
    }

    public NPCTalkResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase quest) {
        QuestBase questBase = progress.getQuest();
        if (questBase instanceof NPCQuest) {
            NPCQuest npcQuest = (NPCQuest)questBase;
            return new NPCTalkResolved(npcQuest.getNpcUuid(), this.predicate);
        }
        return null;
    }

    public static class NPCTalkResolved
    implements ResolvedQuestTask {
        public static final Codec<NPCTalkResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("target_npc").xmap(UUID::fromString, UUID::toString).forGetter(d -> d.targetNPC), (App)JsonCodecs.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> Optional.ofNullable(d.predicate))).apply((Applicative)instance, (target, predicate) -> new NPCTalkResolved((UUID)target, predicate.orElse(null))));
        private final UUID targetNPC;
        private final EntityPredicate predicate;
        private EntityNPCBase npc;

        public NPCTalkResolved(UUID targetNPC, EntityPredicate predicate) {
            this.targetNPC = targetNPC;
            this.predicate = predicate;
        }

        public boolean submit(ServerPlayer player) {
            return false;
        }

        public QuestEntryKey<NPCTalkTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            Component name;
            if (this.npc == null || !this.npc.m_6084_()) {
                this.npc = this.targetNPC == null ? null : (EntityNPCBase)EntityUtil.findFromUUID(EntityNPCBase.class, (Level)player.m_183503_(), (UUID)this.targetNPC);
            }
            if ((name = this.npc == null ? (this.targetNPC != null ? WorldHandler.get((MinecraftServer)player.m_20194_()).npcHandler.getName(this.targetNPC) : null) : this.npc.m_7755_()) != null) {
                return new TranslatableComponent(this.getId().toString(), new Object[]{name});
            }
            return new TranslatableComponent(this.getId().toString() + ".generic");
        }

        public boolean trySubmit(ServerPlayer player, EntityNPCBase npc) {
            return npc.m_142081_().equals(this.targetNPC) && (this.predicate == null || this.predicate.m_36611_(player, (Entity)npc));
        }
    }
}

