/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.util.DescriptiveValue;
import io.github.flemmli97.simplequests_api.util.JsonCodecs;
import java.util.List;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ShippingTask
implements QuestTask<SkillLevelTaskResolved> {
    public static final QuestEntryKey<ShippingTask> ID = new QuestEntryKey(new ResourceLocation("runecraftory", "shipping"));
    public static final Codec<ShippingTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)CodecHelper.nonEmptyList(DescriptiveValue.withTranslation(CodecHelper.ITEM_PREDICATE_CODEC), "Item predicates can't be empty").fieldOf("item_predicates").forGetter(d -> d.itemPredicates), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, ShippingTask::new));
    private final String description;
    private final List<DescriptiveValue<ItemPredicate>> itemPredicates;
    private final NumberProvider amount;

    public ShippingTask(String description, List<DescriptiveValue<ItemPredicate>> itemPredicates, NumberProvider amount) {
        this.description = description;
        this.itemPredicates = itemPredicates;
        this.amount = amount;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.itemPredicates.size() == 1 && this.amount instanceof ConstantValue;
    }

    public MutableComponent translation(ServerPlayer player) {
        if (this.description.isEmpty() && this.simple()) {
            return this.itemPredicates.get(0).getTranslation(this.getId().toString(), new Object[]{this.amount.m_142683_(null)});
        }
        return new TranslatableComponent(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public SkillLevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        LootContext ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (ResourceLocation)base.id);
        DescriptiveValue<ItemPredicate> val = this.itemPredicates.get(ctx.m_78933_().nextInt(this.itemPredicates.size()));
        return new SkillLevelTaskResolved(val, this.amount.m_142683_(ctx));
    }

    public record SkillLevelTaskResolved(DescriptiveValue<ItemPredicate> item, int amount) implements ResolvedQuestTask
    {
        public static final Codec<SkillLevelTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DescriptiveValue.withTranslation((Codec)JsonCodecs.ITEM_PREDICATE_CODEC).fieldOf("item").forGetter(d -> d.item), (App)ExtraCodecs.f_144629_.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, SkillLevelTaskResolved::new));

        public boolean submit(ServerPlayer player) {
            return Platform.INSTANCE.getPlayerData((Player)player).map(d -> d.getPlayerLevel().getLevel() >= this.amount).orElse(false);
        }

        public QuestEntryKey<ShippingTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            return this.item.getTranslation(this.getId().toString(), new Object[]{this.amount});
        }
    }
}

