/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SkillLevelTask
implements QuestTask<SkillLevelTaskResolved> {
    public static final QuestEntryKey<SkillLevelTask> ID = new QuestEntryKey(new ResourceLocation("runecraftory", "skill_level"));
    public static final Codec<SkillLevelTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)CodecHelper.nonEmptyList(CodecUtils.stringEnumCodec(EnumSkills.class, null), "Skill list can't be empty").fieldOf("skill").forGetter(d -> d.skills), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("level").forGetter(d -> d.range)).apply((Applicative)instance, SkillLevelTask::new));
    private final String description;
    private final List<EnumSkills> skills;
    private final NumberProvider range;

    public SkillLevelTask(String description, List<EnumSkills> skills, NumberProvider range) {
        this.description = description;
        this.skills = skills;
        this.range = range;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.skills.size() == 1 && this.range instanceof ConstantValue;
    }

    public MutableComponent translation(ServerPlayer player) {
        if (this.description.isEmpty() && this.simple()) {
            EnumSkills skill = this.skills.get(0);
            return new TranslatableComponent(this.getId().toString(), new Object[]{skill, this.range.m_142683_(null)});
        }
        return new TranslatableComponent(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public SkillLevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        LootContext ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (ResourceLocation)base.id);
        EnumSkills skills = this.skills.get(ctx.m_78933_().nextInt(this.skills.size()));
        return new SkillLevelTaskResolved(skills, this.range.m_142683_(ctx));
    }

    public record SkillLevelTaskResolved(EnumSkills skill, int level) implements ResolvedQuestTask
    {
        public static final Codec<SkillLevelTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.stringEnumCodec(EnumSkills.class, null).fieldOf("skill").forGetter(d -> d.skill), (App)ExtraCodecs.f_144629_.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, SkillLevelTaskResolved::new));

        public boolean submit(ServerPlayer player) {
            return Platform.INSTANCE.getPlayerData((Player)player).map(d -> d.getPlayerLevel().getLevel() >= this.level).orElse(false);
        }

        public QuestEntryKey<SkillLevelTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            return new TranslatableComponent(this.getId().toString(), new Object[]{this.skill, this.level});
        }
    }
}

