/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.util.DescriptiveValue;
import io.github.flemmli97.simplequests_api.util.JsonCodecs;
import java.util.List;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class TamingTask
implements QuestTask<TamingTaskResolved> {
    public static final QuestEntryKey<TamingTask> ID = new QuestEntryKey(new ResourceLocation("runecraftory", "taming"));
    public static final Codec<TamingTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)JsonCodecs.nonEmptyList((Codec)DescriptiveValue.withTranslation((Codec)JsonCodecs.ENTITY_PREDICATE_CODEC), (String)"predicates can't be empty").fieldOf("predicates").forGetter(d -> d.predicates), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, TamingTask::new));
    private final String description;
    private final List<DescriptiveValue<EntityPredicate>> predicates;
    private final NumberProvider amount;

    public TamingTask(String description, List<DescriptiveValue<EntityPredicate>> predicates, NumberProvider amount) {
        this.description = description;
        this.predicates = predicates;
        this.amount = amount;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.predicates.size() == 1 && this.amount instanceof ConstantValue;
    }

    public MutableComponent translation(ServerPlayer player) {
        if (this.description.isEmpty() && this.simple()) {
            return this.predicates.get(0).getTranslation(this.getId().toString(), new Object[]{this.amount.m_142683_(null)});
        }
        return new TranslatableComponent(this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public TamingTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        LootContext ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (ResourceLocation)base.id);
        DescriptiveValue<EntityPredicate> val = this.predicates.get(ctx.m_78933_().nextInt(this.predicates.size()));
        return new TamingTaskResolved(val, this.amount.m_142683_(ctx));
    }

    public record TamingTaskResolved(DescriptiveValue<EntityPredicate> predicate, int amount) implements ResolvedQuestTask
    {
        public static final Codec<TamingTaskResolved> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DescriptiveValue.withTranslation((Codec)JsonCodecs.ENTITY_PREDICATE_CODEC).fieldOf("predicate").forGetter(d -> d.predicate), (App)ExtraCodecs.f_144629_.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, TamingTaskResolved::new));

        public boolean submit(ServerPlayer player) {
            return false;
        }

        public QuestEntryKey<TamingTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            return this.predicate.getTranslation(this.getId().toString(), new Object[]{this.amount});
        }
    }
}

