/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import io.github.flemmli97.runecraftory.common.lib.LibAttributes;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;

public class ModAttributes {
    public static final PlatformRegistry<Attribute> ATTRIBUTES = PlatformUtils.INSTANCE.of(Registry.f_122916_, "runecraftory");
    public static final Collection<RegistryEntrySupplier<Attribute>> ENTITY_ATTRIBUTES = new ArrayList<RegistryEntrySupplier<Attribute>>();
    public static final Collection<RegistryEntrySupplier<Attribute>> PLAYER_ATTRIBUTES = new ArrayList<RegistryEntrySupplier<Attribute>>();
    public static final Comparator<Attribute> SORTED = (o1, o2) -> {
        if (o1 == Attributes.f_22276_ && o2 != Attributes.f_22276_) {
            return -1;
        }
        if (o1 != Attributes.f_22276_ && o2 == Attributes.f_22276_) {
            return 1;
        }
        if (!(o1 instanceof OrderedAttribute) && !(o2 instanceof OrderedAttribute)) {
            return Registry.f_122866_.m_7981_(o1).compareTo(Registry.f_122866_.m_7981_(o2));
        }
        if (o1 instanceof OrderedAttribute) {
            if (o2 instanceof OrderedAttribute) {
                return Integer.compare(((OrderedAttribute)o1).order, ((OrderedAttribute)o2).order);
            }
            return 1;
        }
        return -1;
    };
    private static int ID = 0;
    public static final RegistryEntrySupplier<Attribute> HEALTHGAIN = ModAttributes.registerAdditional(LibAttributes.HEALTH_GAIN, ID++, 0.0, -2.147483648E9, 2.147483647E9);
    public static final RegistryEntrySupplier<Attribute> RPGAIN = ModAttributes.registerAdditional(LibAttributes.RP_GAIN, ID++, 0.0, -2.147483648E9, 2.147483647E9);
    public static final RegistryEntrySupplier<Attribute> RPINCREASE = ModAttributes.registerAdditional(LibAttributes.RP_INCREASE, ID++, 0.0, -2.147483648E9, 2.147483647E9);
    public static final RegistryEntrySupplier<Attribute> DEFENCE = ModAttributes.registerSyncable(LibAttributes.DEFENCE, ID++, 0.0, -9999.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute> MAGIC = ModAttributes.registerSyncable(LibAttributes.MAGIC, ID++, 0.0, -9999.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute> MAGIC_DEFENCE = ModAttributes.registerSyncable(LibAttributes.MAGIC_DEFENCE, ID++, 0.0, -9999.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute> PARA = ModAttributes.register(LibAttributes.PARA, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> POISON = ModAttributes.register(LibAttributes.POISON, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> SEAL = ModAttributes.register(LibAttributes.SEAL, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> SLEEP = ModAttributes.register(LibAttributes.SLEEP, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> FATIGUE = ModAttributes.register(LibAttributes.FATIGUE, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> COLD = ModAttributes.register(LibAttributes.COLD, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> DIZZY = ModAttributes.register(LibAttributes.DIZZY, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> CRIT = ModAttributes.register(LibAttributes.CRIT, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> STUN = ModAttributes.register(LibAttributes.STUN, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> KNOCK = ModAttributes.register(LibAttributes.KNOCK, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> FAINT = ModAttributes.register(LibAttributes.FAINT, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> DRAIN = ModAttributes.register(LibAttributes.DRAIN, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_WATER = ModAttributes.register(LibAttributes.RES_WATER, ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute> RES_EARTH = ModAttributes.register(LibAttributes.RES_EARTH, ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute> RES_WIND = ModAttributes.register(LibAttributes.RES_WIND, ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute> RES_FIRE = ModAttributes.register(LibAttributes.RES_FIRE, ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute> RES_DARK = ModAttributes.register(LibAttributes.RES_DARK, ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute> RES_LIGHT = ModAttributes.register(LibAttributes.RES_LIGHT, ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute> RES_LOVE = ModAttributes.register(LibAttributes.RES_LOVE, ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute> RES_PARA = ModAttributes.register(LibAttributes.RES_PARA, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_POISON = ModAttributes.register(LibAttributes.RES_POISON, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_SEAL = ModAttributes.register(LibAttributes.RES_SEAL, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_SLEEP = ModAttributes.register(LibAttributes.RES_SLEEP, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_FAT = ModAttributes.register(LibAttributes.RES_FATIGUE, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_COLD = ModAttributes.register(LibAttributes.RES_COLD, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_DIZZY = ModAttributes.register(LibAttributes.RES_DIZZY, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_CRIT = ModAttributes.register(LibAttributes.RES_CRIT, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_STUN = ModAttributes.register(LibAttributes.RES_STUN, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_FAINT = ModAttributes.register(LibAttributes.RES_FAINT, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> RES_DRAIN = ModAttributes.register(LibAttributes.RES_DRAIN, ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute> ATTACK_SPEED = ModAttributes.registerPlayerSyncable(LibAttributes.ATTACK_SPEED, ID++, 1.0, 0.0, 2.0);
    public static final RegistryEntrySupplier<Attribute> ATTACK_RANGE = ModAttributes.registerPlayerSyncable(LibAttributes.ATTACK_RANGE, ID++, 3.0, 0.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute> ATTACK_WIDTH = ModAttributes.registerPlayerSyncable(LibAttributes.ATTACK_WIDTH, ID++, 0.0, 0.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute> CHARGE_TIME = ModAttributes.registerPlayerSyncable(LibAttributes.CHARGE_TIME, ID++, 20.0, 0.0, 9999.0);

    private static RegistryEntrySupplier<Attribute> register(ResourceLocation reg, int id, double base, double min, double max) {
        RegistryEntrySupplier sup = ATTRIBUTES.register(reg.m_135815_(), () -> new OrderedAttribute("attribute." + String.valueOf(reg), id, base, min, max));
        ENTITY_ATTRIBUTES.add((RegistryEntrySupplier<Attribute>)sup);
        return sup;
    }

    private static RegistryEntrySupplier<Attribute> registerSyncable(ResourceLocation reg, int id, double base, double min, double max) {
        RegistryEntrySupplier sup = ATTRIBUTES.register(reg.m_135815_(), () -> new OrderedAttribute("attribute." + String.valueOf(reg), id, base, min, max).m_22084_(true));
        ENTITY_ATTRIBUTES.add((RegistryEntrySupplier<Attribute>)sup);
        return sup;
    }

    private static RegistryEntrySupplier<Attribute> registerPlayerSyncable(ResourceLocation reg, int id, double base, double min, double max) {
        RegistryEntrySupplier sup = ATTRIBUTES.register(reg.m_135815_(), () -> new OrderedAttribute("attribute." + String.valueOf(reg), id, base, min, max).m_22084_(true));
        PLAYER_ATTRIBUTES.add((RegistryEntrySupplier<Attribute>)sup);
        return sup;
    }

    private static RegistryEntrySupplier<Attribute> registerAdditional(ResourceLocation reg, int id, double base, double min, double max) {
        return ATTRIBUTES.register(reg.m_135815_(), () -> new OrderedAttribute("attribute." + String.valueOf(reg), id, base, min, max));
    }

    public static class OrderedAttribute
    extends RangedAttribute {
        private final int order;

        public OrderedAttribute(String name, int order, double baseValue, double minValue, double maxValue) {
            super(name, baseValue, minValue, maxValue);
            this.order = order;
        }
    }
}

