/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import io.github.flemmli97.runecraftory.api.enums.EnumMineralTier;
import io.github.flemmli97.runecraftory.common.blocks.BlockAccessory;
import io.github.flemmli97.runecraftory.common.blocks.BlockBossSpawner;
import io.github.flemmli97.runecraftory.common.blocks.BlockBrokenMineral;
import io.github.flemmli97.runecraftory.common.blocks.BlockCashRegister;
import io.github.flemmli97.runecraftory.common.blocks.BlockChemistry;
import io.github.flemmli97.runecraftory.common.blocks.BlockCooking;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockForge;
import io.github.flemmli97.runecraftory.common.blocks.BlockFruitTreeLeaf;
import io.github.flemmli97.runecraftory.common.blocks.BlockGiantCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockHerb;
import io.github.flemmli97.runecraftory.common.blocks.BlockMeltableSnow;
import io.github.flemmli97.runecraftory.common.blocks.BlockMineral;
import io.github.flemmli97.runecraftory.common.blocks.BlockMonsterBarn;
import io.github.flemmli97.runecraftory.common.blocks.BlockQuestboard;
import io.github.flemmli97.runecraftory.common.blocks.BlockShippingBin;
import io.github.flemmli97.runecraftory.common.blocks.BlockSingleTimeSpawner;
import io.github.flemmli97.runecraftory.common.blocks.BlockTreeBase;
import io.github.flemmli97.runecraftory.common.blocks.BlockTreeRoot;
import io.github.flemmli97.runecraftory.common.blocks.BlockTreeSapling;
import io.github.flemmli97.runecraftory.common.blocks.tile.AccessoryBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.BossSpawnerBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.BrokenMineralBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.ChemistryBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.CookingBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.ForgingBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.tile.SingleTimeSpawner;
import io.github.flemmli97.runecraftory.common.blocks.tile.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.ModFeatures;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Material;

public class ModBlocks {
    public static final PlatformRegistry<Block> BLOCKS = PlatformUtils.INSTANCE.of(Registry.f_122901_, "runecraftory");
    public static final PlatformRegistry<BlockEntityType<?>> BLOCK_ENTITY_TYPES = PlatformUtils.INSTANCE.of(Registry.f_122907_, "runecraftory");
    public static final List<RegistryEntrySupplier<Block>> CROPS = new ArrayList<RegistryEntrySupplier<Block>>();
    public static final List<RegistryEntrySupplier<Block>> FLOWERS = new ArrayList<RegistryEntrySupplier<Block>>();
    public static final List<RegistryEntrySupplier<Block>> HERBS = new ArrayList<RegistryEntrySupplier<Block>>();
    public static final Map<RegistryEntrySupplier<Block>, RegistryEntrySupplier<Block>> GIANT_CROP_MAP = new HashMap<RegistryEntrySupplier<Block>, RegistryEntrySupplier<Block>>();
    public static final EnumMap<EnumMineralTier, RegistryEntrySupplier<Block>> MINERAL_MAP = new EnumMap(EnumMineralTier.class);
    public static final EnumMap<EnumMineralTier, RegistryEntrySupplier<Block>> BROKEN_MINERAL_MAP = new EnumMap(EnumMineralTier.class);
    public static final RegistryEntrySupplier<Block> FORGE = BLOCKS.register("forge", () -> new BlockForge(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60955_().m_60913_(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block> COOKING = BLOCKS.register("cooking_table", () -> new BlockCooking(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60955_().m_60913_(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block> CHEMISTRY = BLOCKS.register("chemistry_set", () -> new BlockChemistry(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60955_().m_60913_(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block> ACCESSORY = BLOCKS.register("accessory_workbench", () -> new BlockAccessory(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60955_().m_60913_(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block> MINERAL_IRON = ModBlocks.mineral(EnumMineralTier.IRON);
    public static final RegistryEntrySupplier<Block> MINERAL_TIN = ModBlocks.mineral(EnumMineralTier.TIN);
    public static final RegistryEntrySupplier<Block> MINERAL_SILVER = ModBlocks.mineral(EnumMineralTier.SILVER);
    public static final RegistryEntrySupplier<Block> MINERAL_GOLD = ModBlocks.mineral(EnumMineralTier.GOLD);
    public static final RegistryEntrySupplier<Block> MINERAL_PLATINUM = ModBlocks.mineral(EnumMineralTier.PLATINUM);
    public static final RegistryEntrySupplier<Block> MINERAL_ORICHALCUM = ModBlocks.mineral(EnumMineralTier.ORICHALCUM);
    public static final RegistryEntrySupplier<Block> MINERAL_DIAMOND = ModBlocks.mineral(EnumMineralTier.DIAMOND);
    public static final RegistryEntrySupplier<Block> MINERAL_DRAGONIC = ModBlocks.mineral(EnumMineralTier.DRAGONIC);
    public static final RegistryEntrySupplier<Block> MINERAL_AQUAMARINE = ModBlocks.mineral(EnumMineralTier.AQUAMARINE);
    public static final RegistryEntrySupplier<Block> MINERAL_AMETHYST = ModBlocks.mineral(EnumMineralTier.AMETHYST);
    public static final RegistryEntrySupplier<Block> MINERAL_RUBY = ModBlocks.mineral(EnumMineralTier.RUBY);
    public static final RegistryEntrySupplier<Block> MINERAL_EMERALD = ModBlocks.mineral(EnumMineralTier.EMERALD);
    public static final RegistryEntrySupplier<Block> MINERAL_SAPPHIRE = ModBlocks.mineral(EnumMineralTier.SAPPHIRE);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_IRON = ModBlocks.brokenMineral(EnumMineralTier.IRON);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_TIN = ModBlocks.brokenMineral(EnumMineralTier.TIN);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_SILVER = ModBlocks.brokenMineral(EnumMineralTier.SILVER);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_GOLD = ModBlocks.brokenMineral(EnumMineralTier.GOLD);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_PLATINUM = ModBlocks.brokenMineral(EnumMineralTier.PLATINUM);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_ORICHALCUM = ModBlocks.brokenMineral(EnumMineralTier.ORICHALCUM);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_DIAMOND = ModBlocks.brokenMineral(EnumMineralTier.DIAMOND);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_DRAGONIC = ModBlocks.brokenMineral(EnumMineralTier.DRAGONIC);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_AQUAMARINE = ModBlocks.brokenMineral(EnumMineralTier.AQUAMARINE);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_AMETHYST = ModBlocks.brokenMineral(EnumMineralTier.AMETHYST);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_RUBY = ModBlocks.brokenMineral(EnumMineralTier.RUBY);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_EMERALD = ModBlocks.brokenMineral(EnumMineralTier.EMERALD);
    public static final RegistryEntrySupplier<Block> BROKEN_MINERAL_SAPPHIRE = ModBlocks.brokenMineral(EnumMineralTier.SAPPHIRE);
    public static final RegistryEntrySupplier<Block> BOSS_SPAWNER = BLOCKS.register("boss_spawner", () -> new BlockBossSpawner(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(60.0f, 9999.0f).m_60955_()));
    public static final RegistryEntrySupplier<Block> SHIPPING = BLOCKS.register("shipping_bin", () -> new BlockShippingBin(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(3.0f, 10.0f)));
    public static final RegistryEntrySupplier<Block> SINGLE_SPAWN_BLOCK = BLOCKS.register("one_time_spawner", () -> new BlockSingleTimeSpawner(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(60.0f, 9999.0f).m_60955_()));
    public static final RegistryEntrySupplier<Block> CASH_REGISTER = BLOCKS.register("cash_register", () -> new BlockCashRegister(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(3.0f, 5.0f)));
    public static final RegistryEntrySupplier<Block> MONSTER_BARN = BLOCKS.register("monster_barn", () -> new BlockMonsterBarn(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60918_(SoundType.f_56740_).m_60955_().m_60910_().m_60913_(1.0f, 10000.0f)));
    public static final RegistryEntrySupplier<Block> QUEST_BOARD = BLOCKS.register("quest_board", () -> new BlockQuestboard(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60955_().m_60913_(2.0f, 5.0f)));
    public static final RegistryEntrySupplier<Block> TURNIP = ModBlocks.crop("turnip", () -> ModItems.TURNIP, () -> ModItems.TURNIP_SEEDS);
    public static final RegistryEntrySupplier<Block> TURNIP_PINK = ModBlocks.crop("turnip_pink", () -> ModItems.TURNIP_PINK, () -> ModItems.TURNIP_PINK_SEEDS);
    public static final RegistryEntrySupplier<Block> CABBAGE = ModBlocks.crop("cabbage", () -> ModItems.CABBAGE, () -> ModItems.CABBAGE_SEEDS);
    public static final RegistryEntrySupplier<Block> PINK_MELON = ModBlocks.crop("pink_melon", () -> ModItems.PINK_MELON, () -> ModItems.PINK_MELON_SEEDS);
    public static final RegistryEntrySupplier<Block> PINEAPPLE = ModBlocks.crop("pineapple", () -> ModItems.PINEAPPLE, () -> ModItems.PINEAPPLE_SEEDS);
    public static final RegistryEntrySupplier<Block> STRAWBERRY = ModBlocks.crop("strawberry", () -> ModItems.STRAWBERRY, () -> ModItems.STRAWBERRY_SEEDS);
    public static final RegistryEntrySupplier<Block> GOLDEN_TURNIP = ModBlocks.crop("golden_turnip", () -> ModItems.GOLDEN_TURNIP, () -> ModItems.GOLD_TURNIP_SEEDS);
    public static final RegistryEntrySupplier<Block> GOLDEN_POTATO = ModBlocks.crop("golden_potato", () -> ModItems.GOLDEN_POTATO, () -> ModItems.GOLD_POTATO_SEEDS);
    public static final RegistryEntrySupplier<Block> GOLDEN_PUMPKIN = ModBlocks.crop("golden_pumpkin", () -> ModItems.GOLDEN_PUMPKIN, () -> ModItems.GOLD_PUMPKIN_SEEDS);
    public static final RegistryEntrySupplier<Block> GOLDEN_CABBAGE = ModBlocks.crop("golden_cabbage", () -> ModItems.GOLDEN_CABBAGE, () -> ModItems.GOLD_CABBAGE_SEEDS);
    public static final RegistryEntrySupplier<Block> HOT_HOT_FRUIT = ModBlocks.crop("hot_hot_fruit", () -> ModItems.HOT_HOT_FRUIT, () -> ModItems.HOT_HOT_SEEDS);
    public static final RegistryEntrySupplier<Block> BOK_CHOY = ModBlocks.crop("bok_choy", () -> ModItems.BOK_CHOY, () -> ModItems.BOK_CHOY_SEEDS);
    public static final RegistryEntrySupplier<Block> LEEK = ModBlocks.crop("leek", () -> ModItems.LEEK, () -> ModItems.LEEK_SEEDS);
    public static final RegistryEntrySupplier<Block> RADISH = ModBlocks.crop("radish", () -> ModItems.RADISH, () -> ModItems.RADISH_SEEDS);
    public static final RegistryEntrySupplier<Block> SPINACH = ModBlocks.crop("spinach", () -> ModItems.SPINACH, () -> ModItems.SPINACH_SEEDS);
    public static final RegistryEntrySupplier<Block> GREEN_PEPPER = ModBlocks.crop("green_pepper", () -> ModItems.GREEN_PEPPER, () -> ModItems.GREEN_PEPPER_SEEDS);
    public static final RegistryEntrySupplier<Block> YAM = ModBlocks.crop("yam", () -> ModItems.YAM, () -> ModItems.YAM_SEEDS);
    public static final RegistryEntrySupplier<Block> EGGPLANT = ModBlocks.crop("eggplant", () -> ModItems.EGGPLANT, () -> ModItems.EGGPLANT_SEEDS);
    public static final RegistryEntrySupplier<Block> TOMATO = ModBlocks.crop("tomato", () -> ModItems.TOMATO, () -> ModItems.TOMATO_SEEDS);
    public static final RegistryEntrySupplier<Block> CORN = ModBlocks.crop("corn", () -> ModItems.CORN, () -> ModItems.CORN_SEEDS);
    public static final RegistryEntrySupplier<Block> CUCUMBER = ModBlocks.crop("cucumber", () -> ModItems.CUCUMBER, () -> ModItems.CUCUMBER_SEEDS);
    public static final RegistryEntrySupplier<Block> PUMPKIN = ModBlocks.crop("pumpkin", () -> ModItems.PUMPKIN, () -> ModItems.PUMPKIN_SEEDS);
    public static final RegistryEntrySupplier<Block> ONION = ModBlocks.crop("onion", () -> ModItems.ONION, () -> ModItems.ONION_SEEDS);
    public static final RegistryEntrySupplier<Block> TURNIP_GIANT = ModBlocks.giantCrop("tyrant_turnip", () -> ModItems.TURNIP_GIANT, () -> ModItems.TURNIP_SEEDS, TURNIP);
    public static final RegistryEntrySupplier<Block> TURNIP_PINK_GIANT = ModBlocks.giantCrop("colossal_pink", () -> ModItems.TURNIP_PINK_GIANT, () -> ModItems.TURNIP_PINK_SEEDS, TURNIP_PINK);
    public static final RegistryEntrySupplier<Block> CABBAGE_GIANT = ModBlocks.giantCrop("king_cabbage", () -> ModItems.CABBAGE_GIANT, () -> ModItems.CABBAGE_SEEDS, CABBAGE);
    public static final RegistryEntrySupplier<Block> PINK_MELON_GIANT = ModBlocks.giantCrop("conqueror_melon", () -> ModItems.PINK_MELON_GIANT, () -> ModItems.PINK_MELON_SEEDS, PINK_MELON);
    public static final RegistryEntrySupplier<Block> PINEAPPLE_GIANT = ModBlocks.giantCrop("king_pineapple", () -> ModItems.PINEAPPLE_GIANT, () -> ModItems.PINEAPPLE_SEEDS, PINEAPPLE);
    public static final RegistryEntrySupplier<Block> STRAWBERRY_GIANT = ModBlocks.giantCrop("sultan_strawberry", () -> ModItems.STRAWBERRY_GIANT, () -> ModItems.STRAWBERRY_SEEDS, STRAWBERRY);
    public static final RegistryEntrySupplier<Block> GOLDEN_TURNIP_GIANT = ModBlocks.giantCrop("golden_tyrant_turnip", () -> ModItems.GOLDEN_TURNIP_GIANT, () -> ModItems.GOLD_TURNIP_SEEDS, GOLDEN_TURNIP);
    public static final RegistryEntrySupplier<Block> GOLDEN_POTATO_GIANT = ModBlocks.giantCrop("gold_prince_potato", () -> ModItems.GOLDEN_POTATO_GIANT, () -> ModItems.GOLD_POTATO_SEEDS, GOLDEN_POTATO);
    public static final RegistryEntrySupplier<Block> GOLDEN_PUMPKIN_GIANT = ModBlocks.giantCrop("golden_doom_pumpkin", () -> ModItems.GOLDEN_PUMPKIN_GIANT, () -> ModItems.GOLD_PUMPKIN_SEEDS, PUMPKIN);
    public static final RegistryEntrySupplier<Block> GOLDEN_CABBAGE_GIANT = ModBlocks.giantCrop("golden_king_cabbage", () -> ModItems.GOLDEN_CABBAGE_GIANT, () -> ModItems.GOLD_CABBAGE_SEEDS, CABBAGE_GIANT);
    public static final RegistryEntrySupplier<Block> HOT_HOT_FRUIT_GIANT = ModBlocks.giantCrop("giant_hot_hot_fruit", () -> ModItems.HOT_HOT_FRUIT_GIANT, () -> ModItems.HOT_HOT_SEEDS, HOT_HOT_FRUIT);
    public static final RegistryEntrySupplier<Block> BOK_CHOY_GIANT = ModBlocks.giantCrop("boss_bok_choy", () -> ModItems.BOK_CHOY_GIANT, () -> ModItems.BOK_CHOY_SEEDS, BOK_CHOY);
    public static final RegistryEntrySupplier<Block> LEEK_GIANT = ModBlocks.giantCrop("legendary_leek", () -> ModItems.LEEK_GIANT, () -> ModItems.LEEK_SEEDS, LEEK);
    public static final RegistryEntrySupplier<Block> RADISH_GIANT = ModBlocks.giantCrop("noble_radish", () -> ModItems.RADISH_GIANT, () -> ModItems.RADISH_SEEDS, RADISH);
    public static final RegistryEntrySupplier<Block> SPINACH_GIANT = ModBlocks.giantCrop("sovereign_spinach", () -> ModItems.SPINACH_GIANT, () -> ModItems.SPINACH_SEEDS, SPINACH);
    public static final RegistryEntrySupplier<Block> GREEN_PEPPER_GIANT = ModBlocks.giantCrop("green_pepper_rex", () -> ModItems.GREEN_PEPPER_GIANT, () -> ModItems.GREEN_PEPPER_SEEDS, GREEN_PEPPER);
    public static final RegistryEntrySupplier<Block> YAM_GIANT = ModBlocks.giantCrop("lorldy_yam", () -> ModItems.YAM_GIANT, () -> ModItems.YAM_SEEDS, YAM);
    public static final RegistryEntrySupplier<Block> EGGPLANT_GIANT = ModBlocks.giantCrop("emperor_eggplant", () -> ModItems.EGGPLANT_GIANT, () -> ModItems.EGGPLANT_SEEDS, EGGPLANT);
    public static final RegistryEntrySupplier<Block> TOMATO_GIANT = ModBlocks.giantCrop("titan_tomato", () -> ModItems.TOMATO_GIANT, () -> ModItems.TOMATO_SEEDS, TOMATO);
    public static final RegistryEntrySupplier<Block> CORN_GIANT = ModBlocks.giantCrop("gigant_corn", () -> ModItems.CORN_GIANT, () -> ModItems.CORN_SEEDS, CORN);
    public static final RegistryEntrySupplier<Block> CUCUMBER_GIANT = ModBlocks.giantCrop("kaiser_cucumber", () -> ModItems.CUCUMBER_GIANT, () -> ModItems.CUCUMBER_SEEDS, CUCUMBER);
    public static final RegistryEntrySupplier<Block> PUMPKIN_GIANT = ModBlocks.giantCrop("doom_pumpkin", () -> ModItems.PUMPKIN_GIANT, () -> ModItems.PUMPKIN_SEEDS, PUMPKIN);
    public static final RegistryEntrySupplier<Block> ONION_GIANT = ModBlocks.giantCrop("ultra_onion", () -> ModItems.ONION_GIANT, () -> ModItems.ONION_SEEDS, ONION);
    public static final RegistryEntrySupplier<Block> FODDER = ModBlocks.crop("fodder", () -> ModItems.FODDER, () -> ModItems.FODDER_SEEDS);
    public static final RegistryEntrySupplier<Block> POTATO_GIANT = ModBlocks.crop("potato", () -> () -> Items.f_42620_, () -> () -> Items.f_42620_);
    public static final RegistryEntrySupplier<Block> CARROT_GIANT = ModBlocks.crop("carrot", () -> () -> Items.f_42619_, () -> () -> Items.f_42619_);
    public static final RegistryEntrySupplier<Block> TOYHERB = ModBlocks.flower("toyherb", () -> ModItems.TOYHERB, () -> ModItems.TOYHERB_SEEDS);
    public static final RegistryEntrySupplier<Block> MOONDROP_FLOWER = ModBlocks.flower("moondrop_flower", () -> ModItems.MOONDROP_FLOWER, () -> ModItems.MOONDROP_SEEDS);
    public static final RegistryEntrySupplier<Block> PINK_CAT = ModBlocks.flower("pink_cat", () -> ModItems.PINK_CAT, () -> ModItems.PINK_CAT_SEEDS);
    public static final RegistryEntrySupplier<Block> CHARM_BLUE = ModBlocks.flower("charm_blue", () -> ModItems.CHARM_BLUE, () -> ModItems.CHARM_BLUE_SEEDS);
    public static final RegistryEntrySupplier<Block> LAMP_GRASS = ModBlocks.flower("lamp_grass", () -> ModItems.LAMP_GRASS, () -> ModItems.LAMP_GRASS_SEEDS);
    public static final RegistryEntrySupplier<Block> CHERRY_GRASS = ModBlocks.flower("cherry_grass", () -> ModItems.CHERRY_GRASS, () -> ModItems.CHERRY_GRASS_SEEDS);
    public static final RegistryEntrySupplier<Block> POM_POM_GRASS = ModBlocks.flower("pom_pom_grass", () -> ModItems.POM_POM_GRASS, () -> ModItems.POM_POM_GRASS_SEEDS);
    public static final RegistryEntrySupplier<Block> AUTUMN_GRASS = ModBlocks.flower("autumn_grass", () -> ModItems.AUTUMN_GRASS, () -> ModItems.AUTUMN_GRASS_SEEDS);
    public static final RegistryEntrySupplier<Block> NOEL_GRASS = ModBlocks.flower("noel_grass", () -> ModItems.NOEL_GRASS, () -> ModItems.NOEL_GRASS_SEEDS);
    public static final RegistryEntrySupplier<Block> FIREFLOWER = ModBlocks.flower("fireflower", () -> ModItems.FIREFLOWER, () -> ModItems.FIREFLOWER_SEEDS);
    public static final RegistryEntrySupplier<Block> FOUR_LEAF_CLOVER = ModBlocks.flower("four_leaf_clover", () -> ModItems.FOUR_LEAF_CLOVER, () -> ModItems.FOUR_LEAF_CLOVER_SEEDS);
    public static final RegistryEntrySupplier<Block> IRONLEAF = ModBlocks.flower("ironleaf", () -> ModItems.IRONLEAF, () -> ModItems.IRONLEAF_SEEDS);
    public static final RegistryEntrySupplier<Block> WHITE_CRYSTAL = ModBlocks.flower("white_crystal", () -> ModItems.WHITE_CRYSTAL, () -> ModItems.WHITE_CRYSTAL_SEEDS);
    public static final RegistryEntrySupplier<Block> RED_CRYSTAL = ModBlocks.flower("red_crystal", () -> ModItems.RED_CRYSTAL, () -> ModItems.RED_CRYSTAL_SEEDS);
    public static final RegistryEntrySupplier<Block> GREEN_CRYSTAL = ModBlocks.flower("green_crystal", () -> ModItems.GREEN_CRYSTAL, () -> ModItems.GREEN_CRYSTAL_SEEDS);
    public static final RegistryEntrySupplier<Block> BLUE_CRYSTAL = ModBlocks.flower("blue_crystal", () -> ModItems.BLUE_CRYSTAL, () -> ModItems.BLUE_CRYSTAL_SEEDS);
    public static final RegistryEntrySupplier<Block> EMERY_FLOWER = ModBlocks.flower("emery_flower", () -> ModItems.EMERY_FLOWER, () -> ModItems.EMERY_FLOWER_SEEDS);
    public static final RegistryEntrySupplier<Block> TOYHERB_GIANT = ModBlocks.giantFlower("ultra_toyherb", () -> ModItems.TOYHERB_GIANT, () -> ModItems.TOYHERB_SEEDS, TOYHERB);
    public static final RegistryEntrySupplier<Block> MOONDROP_FLOWER_GIANT = ModBlocks.giantFlower("ultra_moondrop_flower", () -> ModItems.MOONDROP_FLOWER_GIANT, () -> ModItems.MOONDROP_SEEDS, MOONDROP_FLOWER);
    public static final RegistryEntrySupplier<Block> PINK_CAT_GIANT = ModBlocks.giantFlower("king_pink_cat", () -> ModItems.PINK_CAT_GIANT, () -> ModItems.PINK_CAT_SEEDS, PINK_CAT);
    public static final RegistryEntrySupplier<Block> CHARM_BLUE_GIANT = ModBlocks.giantFlower("great_charm_blue", () -> ModItems.CHARM_BLUE_GIANT, () -> ModItems.CHARM_BLUE_SEEDS, CHARM_BLUE);
    public static final RegistryEntrySupplier<Block> LAMP_GRASS_GIANT = ModBlocks.giantFlower("kaiser_lamp_grass", () -> ModItems.LAMP_GRASS_GIANT, () -> ModItems.LAMP_GRASS_SEEDS, LAMP_GRASS);
    public static final RegistryEntrySupplier<Block> CHERRY_GRASS_GIANT = ModBlocks.giantFlower("king_cherry_grass", () -> ModItems.CHERRY_GRASS_GIANT, () -> ModItems.CHERRY_GRASS_SEEDS, CHERRY_GRASS);
    public static final RegistryEntrySupplier<Block> POM_POM_GRASS_GIANT = ModBlocks.giantFlower("king_pom_pom_grass", () -> ModItems.POM_POM_GRASS_GIANT, () -> ModItems.POM_POM_GRASS_SEEDS, POM_POM_GRASS);
    public static final RegistryEntrySupplier<Block> AUTUMN_GRASS_GIANT = ModBlocks.giantFlower("big_autumn_grass", () -> ModItems.AUTUMN_GRASS_GIANT, () -> ModItems.AUTUMN_GRASS_SEEDS, AUTUMN_GRASS);
    public static final RegistryEntrySupplier<Block> NOEL_GRASS_GIANT = ModBlocks.giantFlower("large_noel_grass", () -> ModItems.NOEL_GRASS_GIANT, () -> ModItems.NOEL_GRASS_SEEDS, NOEL_GRASS);
    public static final RegistryEntrySupplier<Block> FIREFLOWER_GIANT = ModBlocks.giantFlower("big_fireflower", () -> ModItems.FIREFLOWER_GIANT, () -> ModItems.FIREFLOWER_SEEDS, FIREFLOWER);
    public static final RegistryEntrySupplier<Block> FOUR_LEAF_CLOVER_GIANT = ModBlocks.giantFlower("great_four_leaf_clover", () -> ModItems.FOUR_LEAF_CLOVER_GIANT, () -> ModItems.FOUR_LEAF_CLOVER_SEEDS, FOUR_LEAF_CLOVER);
    public static final RegistryEntrySupplier<Block> IRONLEAF_GIANT = ModBlocks.giantFlower("super_ironleaf", () -> ModItems.IRONLEAF_GIANT, () -> ModItems.IRONLEAF_SEEDS, IRONLEAF);
    public static final RegistryEntrySupplier<Block> WHITE_CRYSTAL_GIANT = ModBlocks.giantFlower("big_white_crystal", () -> ModItems.WHITE_CRYSTAL_GIANT, () -> ModItems.WHITE_CRYSTAL_SEEDS, WHITE_CRYSTAL);
    public static final RegistryEntrySupplier<Block> RED_CRYSTAL_GIANT = ModBlocks.giantFlower("big_red_crystal", () -> ModItems.RED_CRYSTAL_GIANT, () -> ModItems.RED_CRYSTAL_SEEDS, RED_CRYSTAL);
    public static final RegistryEntrySupplier<Block> GREEN_CRYSTAL_GIANT = ModBlocks.giantFlower("big_green_crystal", () -> ModItems.GREEN_CRYSTAL_GIANT, () -> ModItems.GREEN_CRYSTAL_SEEDS, GREEN_CRYSTAL);
    public static final RegistryEntrySupplier<Block> BLUE_CRYSTAL_GIANT = ModBlocks.giantFlower("big_blue_crystal", () -> ModItems.BLUE_CRYSTAL_GIANT, () -> ModItems.BLUE_CRYSTAL_SEEDS, BLUE_CRYSTAL);
    public static final RegistryEntrySupplier<Block> EMERY_FLOWER_GIANT = ModBlocks.giantFlower("great_emery_flower", () -> ModItems.EMERY_FLOWER_GIANT, () -> ModItems.EMERY_FLOWER_SEEDS, EMERY_FLOWER);
    public static final RegistryEntrySupplier<Block> SHIELD_CROP = ModBlocks.flower("shield_flower", () -> ModItems.PLANT_SHIELD, () -> ModItems.SHIELD_SEEDS);
    public static final RegistryEntrySupplier<Block> SWORD_CROP = ModBlocks.flower("sword_flower", () -> ModItems.PLANT_SWORD, () -> ModItems.SWORD_SEEDS);
    public static final RegistryEntrySupplier<Block> DUNGEON = ModBlocks.flower("dungeon_flower", () -> () -> Items.f_41905_, () -> ModItems.DUNGEON_SEEDS);
    public static final RegistryEntrySupplier<Block> MUSHROOM = ModBlocks.herb("mushroom", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> MONARCH_MUSHROOM = ModBlocks.herb("monarch_mushroom", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> ELLI_LEAVES = ModBlocks.herb("elli_leaves", BlockHerb.GroundTypes.END);
    public static final RegistryEntrySupplier<Block> WITHERED_GRASS = ModBlocks.herb("withered_grass", BlockHerb.GroundTypes.SANDY);
    public static final RegistryEntrySupplier<Block> WEEDS = ModBlocks.herb("weeds", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> WHITE_GRASS = ModBlocks.herb("white_grass", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> INDIGO_GRASS = ModBlocks.herb("indigo_grass", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> PURPLE_GRASS = ModBlocks.herb("purple_grass", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> GREEN_GRASS = ModBlocks.herb("green_grass", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> BLUE_GRASS = ModBlocks.herb("blue_grass", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> YELLOW_GRASS = ModBlocks.herb("yellow_grass", BlockHerb.GroundTypes.SANDY, BlockHerb.GroundTypes.NETHER);
    public static final RegistryEntrySupplier<Block> RED_GRASS = ModBlocks.herb("red_grass", BlockHerb.GroundTypes.NETHER);
    public static final RegistryEntrySupplier<Block> ORANGE_GRASS = ModBlocks.herb("orange_grass", BlockHerb.GroundTypes.SANDY, BlockHerb.GroundTypes.NETHER);
    public static final RegistryEntrySupplier<Block> BLACK_GRASS = ModBlocks.herb("black_grass", BlockHerb.GroundTypes.END);
    public static final RegistryEntrySupplier<Block> ANTIDOTE_GRASS = ModBlocks.herb("antidote_grass", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> MEDICINAL_HERB = ModBlocks.herb("medicinal_herb", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> BAMBOO_SPROUT = ModBlocks.herb("bamboo_sprout", new BlockHerb.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block> SNOW = BLOCKS.register("snow", () -> new BlockMeltableSnow(BlockBehaviour.Properties.m_60939_((Material)Material.f_76308_).m_60977_().m_60978_(0.1f).m_60999_().m_60918_(SoundType.f_56747_).m_60971_((blockState, blockGetter, blockPos) -> (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) >= 8)));
    public static final RegistryEntrySupplier<Block> TREE_SOIL = BLOCKS.register("tree_soil", () -> new BlockTreeRoot(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60918_(SoundType.f_56739_).m_60913_(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<BlockTreeBase> APPLE_TREE = BLOCKS.register("apple_tree", () -> new BlockTreeBase(ModBlocks.logProps(), () -> (ConfiguredFeature)ModFeatures.APPLE_1.m_203334_(), () -> (ConfiguredFeature)ModFeatures.APPLE_2.m_203334_(), () -> (ConfiguredFeature)ModFeatures.APPLE_3.m_203334_(), (Supplier<Item>)ModItems.APPLE_SAPLING));
    public static final RegistryEntrySupplier<Block> APPLE_SAPLING = BLOCKS.register("apple_sapling", () -> new BlockTreeSapling(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), (Supplier<BlockTreeBase>)APPLE_TREE));
    public static final RegistryEntrySupplier<RotatedPillarBlock> APPLE_WOOD = BLOCKS.register("apple_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<Block> APPLE_LEAVES = BLOCKS.register("apple_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60913_(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<Block> APPLE = BLOCKS.register("apple_leaves_fruit", () -> new BlockFruitTreeLeaf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60913_(-1.0f, 99999.0f), () -> Items.f_42410_));
    public static final RegistryEntrySupplier<BlockTreeBase> ORANGE_TREE = BLOCKS.register("orange_tree", () -> new BlockTreeBase(ModBlocks.logProps(), () -> (ConfiguredFeature)ModFeatures.ORANGE_1.m_203334_(), () -> (ConfiguredFeature)ModFeatures.ORANGE_2.m_203334_(), () -> (ConfiguredFeature)ModFeatures.ORANGE_3.m_203334_(), (Supplier<Item>)ModItems.ORANGE_SAPLING));
    public static final RegistryEntrySupplier<Block> ORANGE_SAPLING = BLOCKS.register("orange_sapling", () -> new BlockTreeSapling(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), (Supplier<BlockTreeBase>)ORANGE_TREE));
    public static final RegistryEntrySupplier<RotatedPillarBlock> ORANGE_WOOD = BLOCKS.register("orange_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<Block> ORANGE_LEAVES = BLOCKS.register("orange_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60913_(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<Block> ORANGE = BLOCKS.register("orange_leaves_fruit", () -> new BlockFruitTreeLeaf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60913_(-1.0f, 99999.0f), () -> ModItems.ORANGE.get()));
    public static final RegistryEntrySupplier<BlockTreeBase> GRAPE_TREE = BLOCKS.register("grape_tree", () -> new BlockTreeBase(ModBlocks.logProps(), () -> (ConfiguredFeature)ModFeatures.GRAPE_1.m_203334_(), () -> (ConfiguredFeature)ModFeatures.GRAPE_2.m_203334_(), () -> (ConfiguredFeature)ModFeatures.GRAPE_3.m_203334_(), (Supplier<Item>)ModItems.GRAPE_SAPLING));
    public static final RegistryEntrySupplier<Block> GRAPE_SAPLING = BLOCKS.register("grape_sapling", () -> new BlockTreeSapling(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), (Supplier<BlockTreeBase>)GRAPE_TREE));
    public static final RegistryEntrySupplier<RotatedPillarBlock> GRAPE_WOOD = BLOCKS.register("grape_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<Block> GRAPE_LEAVES = BLOCKS.register("grape_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60913_(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<Block> GRAPE = BLOCKS.register("grape_leaves_fruit", () -> new BlockFruitTreeLeaf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60913_(-1.0f, 99999.0f), () -> ModItems.GRAPES.get()));
    public static final RegistryEntrySupplier<BlockEntityType<BrokenMineralBlockEntity>> BROKEN_MINERAL_TILE = ModBlocks.brokenMineralTile("broken_mineral_tile", BROKEN_MINERAL_MAP.values());
    public static final RegistryEntrySupplier<BlockEntityType<AccessoryBlockEntity>> ACCESSORY_TILE = BLOCK_ENTITY_TYPES.register("accessory_tile", () -> Platform.INSTANCE.blockEntityType(AccessoryBlockEntity::new, (Block)ACCESSORY.get()));
    public static final RegistryEntrySupplier<BlockEntityType<ForgingBlockEntity>> FORGING_TILE = BLOCK_ENTITY_TYPES.register("forge_tile", () -> Platform.INSTANCE.blockEntityType(ForgingBlockEntity::new, (Block)FORGE.get()));
    public static final RegistryEntrySupplier<BlockEntityType<ChemistryBlockEntity>> CHEMISTRY_TILE = BLOCK_ENTITY_TYPES.register("chemistry_tile", () -> Platform.INSTANCE.blockEntityType(ChemistryBlockEntity::new, (Block)CHEMISTRY.get()));
    public static final RegistryEntrySupplier<BlockEntityType<CookingBlockEntity>> COOKING_TILE = BLOCK_ENTITY_TYPES.register("cooking_tile", () -> Platform.INSTANCE.blockEntityType(CookingBlockEntity::new, (Block)COOKING.get()));
    public static final RegistryEntrySupplier<BlockEntityType<BossSpawnerBlockEntity>> BOSS_SPAWNER_TILE = BLOCK_ENTITY_TYPES.register("spawner_tile", () -> Platform.INSTANCE.blockEntityType(BossSpawnerBlockEntity::new, (Block)BOSS_SPAWNER.get()));
    public static final RegistryEntrySupplier<BlockEntityType<SingleTimeSpawner>> SINGLE_SPAWNER_TILE = BLOCK_ENTITY_TYPES.register("single_spawner_tile", () -> Platform.INSTANCE.blockEntityType(SingleTimeSpawner::new, (Block)SINGLE_SPAWN_BLOCK.get()));
    public static final RegistryEntrySupplier<BlockEntityType<MonsterBarnBlockEntity>> MONSTER_BARN_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("monster_barn_block_entity", () -> Platform.INSTANCE.blockEntityType(MonsterBarnBlockEntity::new, (Block)MONSTER_BARN.get()));
    public static final RegistryEntrySupplier<BlockEntityType<TreeBlockEntity>> TREE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("tree", () -> Platform.INSTANCE.blockEntityType(TreeBlockEntity::new, (Block)APPLE_TREE.get(), (Block)ORANGE_TREE.get(), (Block)GRAPE_TREE.get()));

    public static RegistryEntrySupplier<Block> mineral(EnumMineralTier name) {
        RegistryEntrySupplier reg = BLOCKS.register("ore_" + name.m_7912_(), () -> new BlockMineral(name, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(5.0f, 10.0f).m_60999_()));
        MINERAL_MAP.put(name, (RegistryEntrySupplier<Block>)reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block> brokenMineral(EnumMineralTier name) {
        RegistryEntrySupplier reg = BLOCKS.register("ore_broken_" + name.m_7912_(), () -> new BlockBrokenMineral(name, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(30.0f, 15.0f)));
        BROKEN_MINERAL_MAP.put(name, (RegistryEntrySupplier<Block>)reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block> crop(String name, Supplier<Supplier<Item>> crop, Supplier<Supplier<Item>> seed) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new BlockCrop(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60918_(SoundType.f_56740_), (Supplier)crop.get(), (Supplier)seed.get()));
        CROPS.add((RegistryEntrySupplier<Block>)reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block> giantCrop(String name, Supplier<Supplier<Item>> giant, Supplier<Supplier<Item>> seed, RegistryEntrySupplier<Block> crop) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new BlockGiantCrop(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60918_(SoundType.f_56740_), (Supplier)giant.get(), (Supplier)seed.get()));
        CROPS.add((RegistryEntrySupplier<Block>)reg);
        if (Platform.INSTANCE.isDatagen()) {
            GIANT_CROP_MAP.put(crop, (RegistryEntrySupplier<Block>)reg);
        }
        return reg;
    }

    public static RegistryEntrySupplier<Block> flower(String name, Supplier<Supplier<Item>> crop, Supplier<Supplier<Item>> seed) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new BlockCrop(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60918_(SoundType.f_56740_), (Supplier)crop.get(), (Supplier)seed.get()));
        FLOWERS.add((RegistryEntrySupplier<Block>)reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block> giantFlower(String name, Supplier<Supplier<Item>> giant, Supplier<Supplier<Item>> seed, RegistryEntrySupplier<Block> flower) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new BlockGiantCrop(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60918_(SoundType.f_56740_), (Supplier)giant.get(), (Supplier)seed.get()));
        FLOWERS.add((RegistryEntrySupplier<Block>)reg);
        if (Platform.INSTANCE.isDatagen()) {
            GIANT_CROP_MAP.put(flower, (RegistryEntrySupplier<Block>)reg);
        }
        return reg;
    }

    public static RegistryEntrySupplier<Block> herb(String name, BlockHerb.GroundTypes ... types) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new BlockHerb(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60918_(SoundType.f_56740_), types));
        HERBS.add((RegistryEntrySupplier<Block>)reg);
        return reg;
    }

    public static <T> Collection<T> combine(Collection<T> one, Collection<T> other) {
        one.addAll(other);
        return one;
    }

    public static RegistryEntrySupplier<BlockEntityType<BrokenMineralBlockEntity>> brokenMineralTile(String name, Collection<RegistryEntrySupplier<Block>> blocks) {
        return BLOCK_ENTITY_TYPES.register(name, () -> Platform.INSTANCE.blockEntityType(BrokenMineralBlockEntity::new, blocks.stream().map(Supplier::get).collect(Collectors.toSet())));
    }

    private static BlockBehaviour.Properties logProps() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_);
    }
}

