/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import io.github.flemmli97.runecraftory.common.crafting.ArmorRecipe;
import io.github.flemmli97.runecraftory.common.crafting.ChemistryRecipe;
import io.github.flemmli97.runecraftory.common.crafting.CookingRecipe;
import io.github.flemmli97.runecraftory.common.crafting.ForgingRecipe;
import io.github.flemmli97.runecraftory.common.crafting.HammerRemainderRecipe;
import io.github.flemmli97.runecraftory.common.crafting.LevelUpUpgradeRecipe;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import net.minecraft.core.Registry;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class ModCrafting {
    public static final PlatformRegistry<RecipeSerializer<?>> RECIPESERIALIZER = PlatformUtils.INSTANCE.of(Registry.f_122915_, "runecraftory");
    public static final RegistryEntrySupplier<RecipeSerializer<?>> ARMOR_SERIALIZER = RECIPESERIALIZER.register("armor", ArmorRecipe.Serializer::new);
    public static final RegistryEntrySupplier<RecipeSerializer<?>> CHEMISTRY_SERIALIZER = RECIPESERIALIZER.register("chemistry", ChemistryRecipe.Serializer::new);
    public static final RegistryEntrySupplier<RecipeSerializer<?>> COOKING_SERIALIZER = RECIPESERIALIZER.register("cooking", CookingRecipe.Serializer::new);
    public static final RegistryEntrySupplier<RecipeSerializer<?>> FORGING_SERIALIZER = RECIPESERIALIZER.register("forge", ForgingRecipe.Serializer::new);
    public static final RegistryEntrySupplier<RecipeSerializer<?>> LEVEL_UPGRADE_SERIALIZER = RECIPESERIALIZER.register("level_upgrade", LevelUpUpgradeRecipe.Serializer::new);
    public static final RegistryEntrySupplier<RecipeSerializer<?>> HAMMER_REMAINDER_SERIALIZER = RECIPESERIALIZER.register("hammer_remainder", HammerRemainderRecipe.Serializer::new);
    public static final PlatformRegistry<RecipeType<?>> RECIPETYPE = PlatformUtils.INSTANCE.of(Registry.f_122914_, "runecraftory");
    public static final RegistryEntrySupplier<RecipeType<SextupleRecipe>> CHEMISTRY = ModCrafting.reg("chemistry_recipe");
    public static final RegistryEntrySupplier<RecipeType<SextupleRecipe>> ARMOR = ModCrafting.reg("armor_recipe");
    public static final RegistryEntrySupplier<RecipeType<SextupleRecipe>> COOKING = ModCrafting.reg("cooking_recipe");
    public static final RegistryEntrySupplier<RecipeType<SextupleRecipe>> FORGE = ModCrafting.reg("forge_recipe");

    private static <T extends Recipe<?>> RegistryEntrySupplier<RecipeType<T>> reg(final String name) {
        return RECIPETYPE.register(name, () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        });
    }
}

