/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.world.features.ChancedBlockClusterConfig;
import io.github.flemmli97.runecraftory.common.world.features.HerbFeature;
import io.github.flemmli97.runecraftory.common.world.features.HerbFeatureConfig;
import io.github.flemmli97.runecraftory.common.world.features.MineralFeature;
import io.github.flemmli97.runecraftory.common.world.features.trees.FruitLeaveDecorator;
import io.github.flemmli97.runecraftory.common.world.features.trees.FruitTreeSproutConfiguration;
import io.github.flemmli97.runecraftory.common.world.features.trees.FruitTreeSproutFeature;
import io.github.flemmli97.runecraftory.common.world.features.trees.FruitTreeTrunkPlacer;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModFeatures {
    public static final PlatformRegistry<Feature<?>> FEATURES = PlatformUtils.INSTANCE.of(Registry.f_122838_, "runecraftory");
    public static final PlatformRegistry<TrunkPlacerType<?>> TRUNK_PLACER = PlatformUtils.INSTANCE.of(Registry.f_122849_, "runecraftory");
    public static final PlatformRegistry<TreeDecoratorType<?>> TREE_DECORATORS = PlatformUtils.INSTANCE.of(Registry.f_122850_, "runecraftory");
    public static final RegistryEntrySupplier<MineralFeature> MINERALFEATURE = FEATURES.register("mineral_feature", () -> new MineralFeature(ChancedBlockClusterConfig.CODEC));
    public static final RegistryEntrySupplier<HerbFeature> HERBFEATURE = FEATURES.register("herb_feature", () -> new HerbFeature(HerbFeatureConfig.CODEC));
    public static final RegistryEntrySupplier<FruitTreeSproutFeature> FRUIT_SPROUT = FEATURES.register("fruit_tree_sprout", () -> new FruitTreeSproutFeature(FruitTreeSproutConfiguration.CODEC));
    public static final RegistryEntrySupplier<TrunkPlacerType<?>> FRUIT_TRUNK_PLACER = TRUNK_PLACER.register("fruit_tree_trunk", () -> ModFeatures.createTrunkPlacerType(FruitTreeTrunkPlacer.CODEC));
    public static final RegistryEntrySupplier<TreeDecoratorType<?>> FRUIT_DECORATOR = TREE_DECORATORS.register("fruit_decorator", () -> ModFeatures.createTreeDecoratorType(FruitLeaveDecorator.CODEC));
    public static Holder<ConfiguredFeature<?, ?>> APPLE_1;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> APPLE_2;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> APPLE_3;
    public static Holder<ConfiguredFeature<?, ?>> ORANGE_1;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> ORANGE_2;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> ORANGE_3;
    public static Holder<ConfiguredFeature<?, ?>> GRAPE_1;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> GRAPE_2;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> GRAPE_3;
    public static Holder<PlacedFeature> PLACEDHERBFEATURE;
    public static Holder<PlacedFeature> PLACEDNETHERHERBFEATURE;
    public static Holder<PlacedFeature> PLACEDENDHERBFEATURE;
    public static List<Holder<PlacedFeature>> PLACEDMINERALFEATURES;
    public static List<Holder<PlacedFeature>> PLACEDNETHERMINERALFEATURES;

    public static void registerConfiguredFeatures() {
        Holder CONFIGUREDHERBFEATURE = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_123861_, (String)"configured_herb_feature", (Object)new ConfiguredFeature((Feature)((HerbFeature)((Object)HERBFEATURE.get())), (FeatureConfiguration)new HerbFeatureConfig(70, 8, 9, ModFeatures.build())));
        PLACEDHERBFEATURE = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_194653_, (String)"placed_herb_feature", (Object)new PlacedFeature(CONFIGUREDHERBFEATURE, List.of(RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_)));
        PLACEDNETHERHERBFEATURE = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_194653_, (String)"placed_nether_herb_feature", (Object)new PlacedFeature(CONFIGUREDHERBFEATURE, List.of(CountOnEveryLayerPlacement.m_191604_((int)6), RarityFilter.m_191900_((int)8))));
        PLACEDENDHERBFEATURE = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_194653_, (String)"placed_end_herb_feature", (Object)new PlacedFeature(CONFIGUREDHERBFEATURE, List.of(RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_)));
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ImmutableList.Builder nether = new ImmutableList.Builder();
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_IRON, null, RunecraftoryTags.WATER_NETHER_END, 15, 2, 5);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_TIN, null, RunecraftoryTags.WATER_NETHER_END, 20, 2, 4);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_SILVER, null, RunecraftoryTags.WATER_NETHER_END, 40, 2, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_GOLD, null, RunecraftoryTags.WATER_NETHER_END, 60, 2, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_PLATINUM, null, RunecraftoryTags.WATER_NETHER_END, 100, 1, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_ORICHALCUM, null, RunecraftoryTags.WATER_NETHER_END, 175, 1, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_DIAMOND, null, RunecraftoryTags.WATER_NETHER_END, 133, 1, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_DRAGONIC, RunecraftoryTags.IS_END, null, 25, 1, 2);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_AQUAMARINE, RunecraftoryTags.AQUAMARINE_GEN, RunecraftoryTags.NETHER_END, 25, 2, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_AMETHYST, RunecraftoryTags.AMETHYST_GEN, RunecraftoryTags.WATER_NETHER_END, 66, 2, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_RUBY, RunecraftoryTags.RUBY_GEN, null, 50, 2, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_EMERALD, RunecraftoryTags.EMERALD_GEN, RunecraftoryTags.WATER_NETHER_END, 66, 1, 3);
        ModFeatures.registerMineralFeatures((ImmutableList.Builder<Holder<PlacedFeature>>)builder, (ImmutableList.Builder<Holder<PlacedFeature>>)nether, ModBlocks.MINERAL_SAPPHIRE, RunecraftoryTags.SAPPHIRE_GEN, RunecraftoryTags.WATER_NETHER_END, 66, 2, 3);
        PLACEDMINERALFEATURES = builder.build();
        PLACEDNETHERMINERALFEATURES = nether.build();
        APPLE_1 = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:apple_stage_1", ModFeatures.fruitSprout((Block)ModBlocks.APPLE_WOOD.get(), (Block)ModBlocks.APPLE_LEAVES.get()));
        APPLE_2 = BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:apple_stage_2", ModFeatures.fruitTree((Block)ModBlocks.APPLE_WOOD.get(), (Block)ModBlocks.APPLE_LEAVES.get(), (Block)ModBlocks.APPLE.get(), false));
        APPLE_3 = BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:apple_stage_3", ModFeatures.fruitTree((Block)ModBlocks.APPLE_WOOD.get(), (Block)ModBlocks.APPLE_LEAVES.get(), (Block)ModBlocks.APPLE.get(), true));
        ORANGE_1 = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:orange_stage_1", ModFeatures.fruitSprout((Block)ModBlocks.ORANGE_WOOD.get(), (Block)ModBlocks.ORANGE_LEAVES.get()));
        ORANGE_2 = BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:orange_stage_2", ModFeatures.fruitTree((Block)ModBlocks.ORANGE_WOOD.get(), (Block)ModBlocks.ORANGE_LEAVES.get(), (Block)ModBlocks.ORANGE.get(), false));
        ORANGE_3 = BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:orange_stage_3", ModFeatures.fruitTree((Block)ModBlocks.ORANGE_WOOD.get(), (Block)ModBlocks.ORANGE_LEAVES.get(), (Block)ModBlocks.ORANGE.get(), true));
        GRAPE_1 = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:grape_stage_1", ModFeatures.fruitSprout((Block)ModBlocks.GRAPE_WOOD.get(), (Block)ModBlocks.GRAPE_LEAVES.get()));
        GRAPE_2 = BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:grape_stage_2", ModFeatures.fruitTree((Block)ModBlocks.GRAPE_WOOD.get(), (Block)ModBlocks.GRAPE_LEAVES.get(), (Block)ModBlocks.GRAPE.get(), false));
        GRAPE_3 = BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)"runecraftory:grape_stage_3", ModFeatures.fruitTree((Block)ModBlocks.GRAPE_WOOD.get(), (Block)ModBlocks.GRAPE_LEAVES.get(), (Block)ModBlocks.GRAPE.get(), true));
    }

    public static List<HerbFeature.Entry> build() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.WEEDS.get(), null, RunecraftoryTags.WATER_NETHER_END, 100));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.MUSHROOM.get(), RunecraftoryTags.MUSHROOM_GEN, RunecraftoryTags.WATER_NETHER_END, 40));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.MONARCH_MUSHROOM.get(), RunecraftoryTags.MUSHROOM_GEN, RunecraftoryTags.WATER_NETHER_END, 10));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.WITHERED_GRASS.get(), null, RunecraftoryTags.WATER_NETHER_END, 50));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.WHITE_GRASS.get(), RunecraftoryTags.IS_SNOWY, RunecraftoryTags.WATER_NETHER_END, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.INDIGO_GRASS.get(), RunecraftoryTags.INDIGO_GEN, RunecraftoryTags.WATER_NETHER_END, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.PURPLE_GRASS.get(), RunecraftoryTags.PURPLE_GEN, RunecraftoryTags.WATER_NETHER_END, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.GREEN_GRASS.get(), RunecraftoryTags.GENERAL_HERBS, RunecraftoryTags.WATER_NETHER_END, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.BLUE_GRASS.get(), RunecraftoryTags.BLUE_GEN, RunecraftoryTags.NETHER_END, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.YELLOW_GRASS.get(), RunecraftoryTags.YELLOW_GEN, RunecraftoryTags.WATER_END, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.RED_GRASS.get(), (TagKey<Biome>)BiomeTags.f_207612_, null, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.ORANGE_GRASS.get(), RunecraftoryTags.ORANGE_GEN, RunecraftoryTags.WATER_END, 30));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.BLACK_GRASS.get(), RunecraftoryTags.IS_END, null, 75));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.ELLI_LEAVES.get(), RunecraftoryTags.IS_END, null, 10));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.ANTIDOTE_GRASS.get(), RunecraftoryTags.GENERAL_HERBS, RunecraftoryTags.WATER_NETHER_END, 75));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.MEDICINAL_HERB.get(), RunecraftoryTags.GENERAL_HERBS, RunecraftoryTags.WATER_NETHER_END, 75));
        builder.add((Object)new HerbFeature.Entry((Block)ModBlocks.BAMBOO_SPROUT.get(), RunecraftoryTags.BAMBOO_GEN, RunecraftoryTags.WATER_NETHER_END, 66));
        return builder.build();
    }

    private static void registerMineralFeatures(ImmutableList.Builder<Holder<PlacedFeature>> builder, ImmutableList.Builder<Holder<PlacedFeature>> nether, RegistryEntrySupplier<Block> block, TagKey<Biome> whitelist, TagKey<Biome> blacklist, int chance, int min, int max) {
        Holder CONFIGUREDMINERALFEATURE = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_123861_, (String)("runecraftory:configured_mineral_feature" + block.getID().m_135815_()), (Object)new ConfiguredFeature((Feature)((MineralFeature)((Object)MINERALFEATURE.get())), (FeatureConfiguration)new ChancedBlockClusterConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)block.get())), whitelist, blacklist, min, max, 3, 64)));
        builder.add((Object)BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_194653_, (String)("runecraftory:placed_mineral_feature_" + block.getID().m_135815_()), (Object)new PlacedFeature(CONFIGUREDMINERALFEATURE, List.of(RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), PlacementUtils.f_195353_))));
        nether.add((Object)BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_194653_, (String)("runecraftory:placed_nether_mineral_feature" + block.getID().m_135815_()), (Object)new PlacedFeature(CONFIGUREDMINERALFEATURE, List.of(CountOnEveryLayerPlacement.m_191604_((int)5), RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_()))));
    }

    private static ConfiguredFeature<FruitTreeSproutConfiguration, ?> fruitSprout(Block log, Block leave) {
        return new ConfiguredFeature((Feature)((FruitTreeSproutFeature)((Object)FRUIT_SPROUT.get())), (FeatureConfiguration)new FruitTreeSproutConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)log), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leave)));
    }

    private static ConfiguredFeature<TreeConfiguration, ?> fruitTree(Block log, Block leave, Block fruit, boolean max) {
        return new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)log), (TrunkPlacer)new FruitTreeTrunkPlacer(max ? 3 : 1, 1, max ? 2 : 1, max ? 3 : 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leave), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)(max ? ConstantInt.m_146483_((int)2) : ConstantInt.m_146483_((int)1)), (IntProvider)ConstantInt.m_146483_((int)0), max ? 3 : 2), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68249_(max ? List.of(new FruitLeaveDecorator((BlockStateProvider)BlockStateProvider.m_191382_((Block)fruit))) : List.of()).m_68244_().m_68251_());
    }

    private static TrunkPlacerType<?> createTrunkPlacerType(Codec<? extends TrunkPlacer> codec) {
        try {
            Constructor cons = TrunkPlacerType.class.getDeclaredConstructor(Codec.class);
            cons.setAccessible(true);
            return (TrunkPlacerType)cons.newInstance(codec);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            RuneCraftory.LOGGER.error((Object)e);
            return null;
        }
    }

    private static TreeDecoratorType<?> createTreeDecoratorType(Codec<? extends TreeDecorator> codec) {
        try {
            Constructor cons = TreeDecoratorType.class.getDeclaredConstructor(Codec.class);
            cons.setAccessible(true);
            return (TreeDecoratorType)cons.newInstance(codec);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

