/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.flemmli97.runecraftory.common.entities.npc.job.BathhouseAttendant;
import io.github.flemmli97.runecraftory.common.entities.npc.job.Cook;
import io.github.flemmli97.runecraftory.common.entities.npc.job.Doctor;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.entities.npc.job.Smith;
import io.github.flemmli97.runecraftory.common.registry.ModPoiTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;

public class ModNPCJobs {
    public static final Codec<NPCJob> CODEC = ResourceLocation.f_135803_.flatXmap(res -> ModNPCJobs.getOptional(res).map(DataResult::success).orElse(DataResult.error((String)("Unknown job: " + String.valueOf(res)))), val -> ModNPCJobs.getOptionalIDFrom(val).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Job not registered:" + String.valueOf(val)))));
    public static final List<ResourceLocation> DEFAULT_JOB_ID = new ArrayList<ResourceLocation>();
    private static int I = 0;
    private static final BiMap<ResourceLocation, NPCJob> JOBREGISTRY = HashBiMap.create();
    private static final BiMap<Integer, NPCJob> JOBREGISTRY_ID = HashBiMap.create();
    private static final ResourceLocation DEFAULT_KEY = new ResourceLocation("runecraftory", "jobless");
    public static final Pair<ResourceLocation, NPCJob> NONE = ModNPCJobs.register(DEFAULT_KEY, new NPCJob(new NPCJob.Builder(null).noShop().noWorkSchedule()));
    public static final Pair<ResourceLocation, NPCJob> GENERAL = ModNPCJobs.register("general_store", new NPCJob(new NPCJob.Builder(() -> PoiType.f_27336_)));
    public static final Pair<ResourceLocation, NPCJob> FLOWER = ModNPCJobs.register("florist", new NPCJob(new NPCJob.Builder(() -> PoiType.f_27336_)));
    public static final Pair<ResourceLocation, NPCJob> SMITH = ModNPCJobs.register("smith", (NPCJob)new Smith(new NPCJob.Builder(() -> PoiType.f_27344_)));
    public static final Pair<ResourceLocation, NPCJob> DOCTOR = ModNPCJobs.register("doctor", (NPCJob)new Doctor(new NPCJob.Builder(() -> PoiType.f_27335_)));
    public static final Pair<ResourceLocation, NPCJob> COOK = ModNPCJobs.register("cook", (NPCJob)new Cook(new NPCJob.Builder(() -> PoiType.f_27333_)));
    public static final Pair<ResourceLocation, NPCJob> MAGIC = ModNPCJobs.register("magicskill_merchant", new NPCJob(new NPCJob.Builder((Supplier<PoiType>)ModPoiTypes.CASH_REGISTER)));
    public static final Pair<ResourceLocation, NPCJob> RUNE_SKILLS = ModNPCJobs.register("runeskill_merchant", new NPCJob(new NPCJob.Builder((Supplier<PoiType>)ModPoiTypes.CASH_REGISTER)));
    public static final Pair<ResourceLocation, NPCJob> BATHHOUSE = ModNPCJobs.register("bathhouse_attendant", (NPCJob)new BathhouseAttendant(new NPCJob.Builder((Supplier<PoiType>)ModPoiTypes.CASH_REGISTER).noShop()));
    public static final Pair<ResourceLocation, NPCJob> RANDOM = ModNPCJobs.register("travelling_merchant", new NPCJob(new NPCJob.Builder(null).noSchedule()));
    private static List<NPCJob> ALLJOBS;

    private static Pair<ResourceLocation, NPCJob> register(String name, NPCJob job) {
        ResourceLocation res = new ResourceLocation("runecraftory", name);
        Pair<ResourceLocation, NPCJob> pair = ModNPCJobs.register(res, job);
        DEFAULT_JOB_ID.add(res);
        return pair;
    }

    public static Pair<ResourceLocation, NPCJob> register(ResourceLocation res, NPCJob job) {
        if (JOBREGISTRY.containsKey((Object)res)) {
            throw new IllegalStateException("An entry with key " + String.valueOf(res) + " is already registered");
        }
        JOBREGISTRY.put((Object)res, (Object)job);
        JOBREGISTRY_ID.put((Object)I++, (Object)job);
        return Pair.of((Object)res, (Object)job);
    }

    public static NPCJob getFromID(ResourceLocation res) {
        return (NPCJob)JOBREGISTRY.getOrDefault((Object)res, (Object)((NPCJob)NONE.getSecond()));
    }

    public static Optional<NPCJob> getOptional(ResourceLocation res) {
        return Optional.ofNullable((NPCJob)JOBREGISTRY.get((Object)res));
    }

    public static ResourceLocation getIDFrom(NPCJob job) {
        ResourceLocation res = (ResourceLocation)JOBREGISTRY.inverse().get((Object)job);
        return res == null ? (ResourceLocation)JOBREGISTRY.inverse().get((Object)job) : res;
    }

    public static Optional<ResourceLocation> getOptionalIDFrom(NPCJob job) {
        return Optional.ofNullable((ResourceLocation)JOBREGISTRY.inverse().get((Object)job));
    }

    public static List<NPCJob> allJobs() {
        if (ALLJOBS == null) {
            ALLJOBS = JOBREGISTRY_ID.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).toList();
        }
        return ALLJOBS;
    }

    public static List<NPCJob> jobsWithShops() {
        return ModNPCJobs.allJobs().stream().filter(j -> j.hasShop).toList();
    }

    public static NPCJob getRandomJob(Random random) {
        return ModNPCJobs.allJobs().get(random.nextInt(ModNPCJobs.allJobs().size()));
    }

    public static NPCJob getFromSyncID(int id) {
        return (NPCJob)JOBREGISTRY_ID.getOrDefault((Object)id, (Object)((NPCJob)NONE.getSecond()));
    }

    public static int getSyncIDFrom(NPCJob job) {
        return (Integer)JOBREGISTRY_ID.inverse().getOrDefault((Object)job, (Object)-1);
    }

    public static ResourceLocation legacyOfTag(Tag tag) {
        if (tag == null) {
            return DEFAULT_KEY;
        }
        if (tag.m_7060_() == 8) {
            return new ResourceLocation(tag.m_7916_());
        }
        if (tag.m_7060_() == 99) {
            int id = ((NumericTag)tag).m_7047_();
            return switch (id) {
                case 0 -> (ResourceLocation)NONE.getFirst();
                case 1 -> (ResourceLocation)GENERAL.getFirst();
                case 2 -> (ResourceLocation)FLOWER.getFirst();
                case 3 -> (ResourceLocation)SMITH.getFirst();
                case 4 -> (ResourceLocation)DOCTOR.getFirst();
                case 5 -> (ResourceLocation)COOK.getFirst();
                case 6 -> (ResourceLocation)MAGIC.getFirst();
                case 7 -> (ResourceLocation)RUNE_SKILLS.getFirst();
                case 8 -> (ResourceLocation)RANDOM.getFirst();
                default -> DEFAULT_KEY;
            };
        }
        return DEFAULT_KEY;
    }
}

