/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;

public class ModSounds {
    public static final PlatformRegistry<SoundEvent> SOUND_EVENTS = PlatformUtils.INSTANCE.of(Registry.f_122898_, "runecraftory");
    public static final Object2IntMap<ResourceLocation> VARIATIONS = new Object2IntArrayMap();
    public static final List<BGMHolder> BGM = new ArrayList<BGMHolder>();
    public static final Map<ResourceLocation, RegistryEntrySupplier<Item>> BGM_RECORD = new HashMap<ResourceLocation, RegistryEntrySupplier<Item>>();
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_AMBROSIA_WAVE = ModSounds.register("entity.ambrosia.wave");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_CHIMERA_AMBIENT = ModSounds.register("entity.chimera.ambient", 2);
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_CHIPSQUEEK_HURT = ModSounds.register("entity.chipsqueek.hurt", 2);
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_DEAD_TREE_DEATH = ModSounds.register("entity.dead_tree.death");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_FAIRY_AMBIENT = ModSounds.register("entity.fairy.ambient");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_FLOWER_LILY_STEP = ModSounds.register("entity.flower_lily.step", 2);
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_GENERIC_HEAVY_CHARGE = ModSounds.register("entity.generic.heavy_charge");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_GHOST_AMBIENT = ModSounds.register("entity.ghost.ambient", 3);
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_GOBLING_AMBIENT = ModSounds.register("entity.goblin.ambient", 3);
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_GOBLING_HURT = ModSounds.register("entity.goblin.hurt");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_GOBLIN_DEATH = ModSounds.register("entity.goblin.death");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_ORC_BONK = ModSounds.register("entity.orc.bonk");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_PANTHER_AMBIENT = ModSounds.register("entity.panther.ambient");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_PANTHER_HURT = ModSounds.register("entity.panther.hurt");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_RAFFLESIA_ANGRY = ModSounds.register("entity.rafflesia.angry");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_RAFFLESIA_DEATH = ModSounds.register("entity.rafflesia.death");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_SCORPION_STEP = ModSounds.register("entity.scorpion.step");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_SKELEFANG_ROAR = ModSounds.register("entity.skelefang.roar");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_THUNDERBOLT_NEIGH = ModSounds.register("entity.thunderbolt.neigh");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_WASP_BUZZ = ModSounds.register("entity.wasp.buzz", 3);
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_WEAGLE_FLAP = ModSounds.register("entity.weagle.flap");
    public static final RegistryEntrySupplier<SoundEvent> ENTITY_WISP_AMBIENT = ModSounds.register("entity.wisp.ambient");
    public static final RegistryEntrySupplier<SoundEvent> PLAYER_ATTACK_SWOOSH = ModSounds.register("player.attack.swoosh", 4);
    public static final RegistryEntrySupplier<SoundEvent> PLAYER_ATTACK_SWOOSH_HEAVY = ModSounds.register("player.attack.swoosh_heavy");
    public static final RegistryEntrySupplier<SoundEvent> PLAYER_ATTACK_SWOOSH_LIGHT = ModSounds.register("player.attack.swoosh_light", 3);
    public static final RegistryEntrySupplier<SoundEvent> PLAYER_ARMOR_PIYO_CHIRP = ModSounds.register("player.armor.piyo_chirp", 4);
    public static final RegistryEntrySupplier<SoundEvent> SPELL_APPLE_RAIN = ModSounds.register("spell.apple_rain");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_BUFF = ModSounds.register("spell.generic.buff");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_DARK = ModSounds.register("spell.generic.dark");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_ELECTRIC_ZAP = ModSounds.register("spell.generic.electric_zap");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_FIRE_BALL = ModSounds.register("spell.generic.fireball");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_HEAL = ModSounds.register("spell.generic.heal", 3);
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_LEAP = ModSounds.register("spell.generic.leap");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_LIGHT = ModSounds.register("spell.generic.light");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_POOF = ModSounds.register("spell.generic.poof");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_POP = ModSounds.register("spell.generic.pop");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_ROCKS = ModSounds.register("spell.generic.rocks");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_WATER = ModSounds.register("spell.generic.wave");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_WATERBUBBLE = ModSounds.register("spell.generic.water_bubble");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_WIND = ModSounds.register("spell.generic.wind");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_GENERIC_WIND_LONG = ModSounds.register("spell.generic.wind_long");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_NAIVE_BLADE = ModSounds.register("spell.naive_blade");
    public static final RegistryEntrySupplier<SoundEvent> SPELL_STRAIGHT_PUNCH = ModSounds.register("spell.straight_punch");
    public static final ResourceLocation BGM_1 = new ResourceLocation("runecraftory", "bgm/aiwa-konomunede-kuchiteyuku");
    public static final ResourceLocation BGM_2 = new ResourceLocation("runecraftory", "bgm/area-12");
    public static final ResourceLocation BGM_3 = new ResourceLocation("runecraftory", "bgm/catch-them-all");
    public static final ResourceLocation BGM_4 = new ResourceLocation("runecraftory", "bgm/cruising-down-8bit-lane");
    public static final ResourceLocation BGM_5 = new ResourceLocation("runecraftory", "bgm/yami-no-sekai-no-tatakai");
    public static final ResourceLocation BGM_6 = new ResourceLocation("runecraftory", "bgm/yurei");
    public static final ResourceLocation BGM_7 = new ResourceLocation("runecraftory", "bgm/golem_battle");
    public static final RegistryEntrySupplier<SoundEvent> AMBROSIA_FIGHT = ModSounds.registerBgm("bgm.ambrosia_fight", BGM_4);
    public static final RegistryEntrySupplier<SoundEvent> CHIMERA_FIGHT = ModSounds.registerBgm("bgm.chimera_fight", BGM_2);
    public static final RegistryEntrySupplier<SoundEvent> DEAD_TREE_FIGHT = ModSounds.registerBgm("bgm.dead_tree_fight", BGM_2);
    public static final RegistryEntrySupplier<SoundEvent> MARIONETTA_FIGHT = ModSounds.registerBgm("bgm.marionetta_fight", BGM_6);
    public static final RegistryEntrySupplier<SoundEvent> HANDONETTA_FIGHT = ModSounds.registerBgm("bgm.handonetta_fight", BGM_6);
    public static final RegistryEntrySupplier<SoundEvent> RACCOON_FIGHT = ModSounds.registerBgm("bgm.raccoon_fight", BGM_1);
    public static final RegistryEntrySupplier<SoundEvent> SKELEFANG_FIGHT = ModSounds.registerBgm("bgm.skelefang_fight", BGM_5);
    public static final RegistryEntrySupplier<SoundEvent> RAFFLESIA_FIGHT = ModSounds.registerBgm("bgm.rafflesia_fight", BGM_3);
    public static final RegistryEntrySupplier<SoundEvent> THUNDERBOLT_FIGHT = ModSounds.registerBgm("bgm.thunderbolt_fight", BGM_4);
    public static final RegistryEntrySupplier<SoundEvent> GRIMOIRE_FIGHT = ModSounds.registerBgm("bgm.grimoire_fight", BGM_2);
    public static final RegistryEntrySupplier<SoundEvent> SANO_UNO_FIGHT = ModSounds.registerBgm("bgm.sano_uno_fight", BGM_4);
    public static final RegistryEntrySupplier<SoundEvent> SARCOPHAGUS_FIGHT = ModSounds.registerBgm("bgm.sarcophagus_fight", BGM_7);

    private static RegistryEntrySupplier<SoundEvent> register(String name) {
        return SOUND_EVENTS.register(name, () -> new SoundEvent(new ResourceLocation("runecraftory", name)));
    }

    private static RegistryEntrySupplier<SoundEvent> register(String name, int variations) {
        RegistryEntrySupplier res = SOUND_EVENTS.register(name, () -> new SoundEvent(new ResourceLocation("runecraftory", name)));
        if (Platform.INSTANCE.isDatagen()) {
            VARIATIONS.put((Object)res.getID(), variations);
        }
        return res;
    }

    private static RegistryEntrySupplier<SoundEvent> registerBgm(String name, ResourceLocation bgm) {
        RegistryEntrySupplier res = SOUND_EVENTS.register(name, () -> new SoundEvent(new ResourceLocation("runecraftory", name)));
        BGM.add(new BGMHolder((RegistryEntrySupplier<SoundEvent>)res, bgm));
        return res;
    }

    public record BGMHolder(RegistryEntrySupplier<SoundEvent> sound, ResourceLocation bgm) {
    }
}

