/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.world.structure.NetherJigsawStructure;
import io.github.flemmli97.runecraftory.common.world.structure.SurfaceJigsawStructure;
import io.github.flemmli97.runecraftory.common.world.structure.processors.BossSpawnerProcessor;
import io.github.flemmli97.runecraftory.common.world.structure.processors.NPCDataProcessor;
import io.github.flemmli97.runecraftory.common.world.structure.processors.WaterUnlogProcessor;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public class ModStructures {
    public static final PlatformRegistry<StructureFeature<?>> STRUCTURES = PlatformUtils.INSTANCE.of(Registry.f_122840_, "runecraftory");
    public static final PlatformRegistry<StructureProcessorType<?>> STRUCTURESPROCESSORS = PlatformUtils.INSTANCE.of(Registry.f_122854_, "runecraftory");
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> FOREST_GROVE = ModStructures.register("forest_grove", () -> new SurfaceJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> WATER_RUINS = ModStructures.register("water_ruins", () -> new SurfaceJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> THEATER_RUINS = ModStructures.register("theater_ruins", () -> new SurfaceJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> PLAINS_ARENA = ModStructures.register("plains_arena", () -> new SurfaceJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> DESERT_ARENA = ModStructures.register("desert_arena", () -> new SurfaceJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> NETHER_ARENA = ModStructures.register("nether_arena", () -> new NetherJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_, 40, 80));
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> WIND_SHRINE = ModStructures.register("wind_shrine", () -> new SurfaceJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryEntrySupplier<StructureFeature<JigsawConfiguration>> LEON_KARNAK = ModStructures.register("leon_karnak", () -> new SurfaceJigsawStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryEntrySupplier<StructureProcessorType<BossSpawnerProcessor>> BOSS_PROCESSOR = STRUCTURESPROCESSORS.register("boss_processor", () -> () -> BossSpawnerProcessor.CODEC);
    public static final RegistryEntrySupplier<StructureProcessorType<NPCDataProcessor>> NPC_PROCESSOR = STRUCTURESPROCESSORS.register("npc_processor", () -> () -> NPCDataProcessor.CODEC);
    public static final RegistryEntrySupplier<StructureProcessorType<WaterUnlogProcessor>> WATERUNLOG_PROCESSOR = STRUCTURESPROCESSORS.register("water_unlog_processor", () -> () -> WaterUnlogProcessor.CODEC);
    public static final Map<ResourceLocation, Holder<StructureProcessorList>> NPC_PROCESSOR_LIST = ModStructures.registerNPCProcessorLists();

    public static <T extends FeatureConfiguration> RegistryEntrySupplier<StructureFeature<T>> register(String name, Supplier<StructureFeature<T>> sup) {
        return STRUCTURES.register(name, sup);
    }

    private static Map<ResourceLocation, Holder<StructureProcessorList>> registerNPCProcessorLists() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ResourceLocation shop : ModNPCJobs.DEFAULT_JOB_ID) {
            Holder holder = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123863_, (ResourceLocation)new ResourceLocation("runecraftory", "npc_" + shop.m_135815_()), (Object)new StructureProcessorList((List)ImmutableList.of((Object)((Object)new NPCDataProcessor(shop)))));
            map.put((Object)shop, (Object)holder);
        }
        return map.build();
    }
}

