/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityAppleProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AppleRain
extends Spell {
    private final Type type;

    public AppleRain(Type type) {
        this.type = type;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int apples = switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NORMAL -> 64;
            case Type.BIG -> 50;
            case Type.LOTS -> 96;
        };
        int range = switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NORMAL -> 9;
            case Type.BIG -> 10;
            case Type.LOTS -> 12;
        };
        for (int i = 0; i < apples; ++i) {
            EntityAppleProjectile apple = new EntityAppleProjectile((Level)level, entity);
            if (this.type == Type.BIG) {
                apple.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.2f));
                apple.withSizeInc(1.0f);
            } else {
                apple.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.1f));
            }
            double x = entity.m_20185_() + (entity.m_21187_().nextDouble() - 0.5) * (double)range;
            double y = entity.m_20186_() + (double)entity.m_20206_() + 2.0 + entity.m_21187_().nextDouble() * 4.0;
            double z = entity.m_20189_() + (entity.m_21187_().nextDouble() - 0.5) * (double)range;
            apple.m_6034_(x, y, z);
            level.m_7967_((Entity)apple);
        }
        AppleRain.playSound(entity, (SoundEvent)ModSounds.SPELL_APPLE_RAIN.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.2f);
        return true;
    }

    public static enum Type {
        NORMAL,
        BIG,
        LOTS;

    }
}

