/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityElementalBall;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BaseStaffSpell
extends Spell {
    private static final float[] OFFSET_TWO = new float[]{-0.6f, 0.6f};
    private static final float[] OFFSET_THREE = new float[]{-1.2f, 0.0f, 1.2f};

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean use(ServerLevel world, LivingEntity entity, ItemStack stack) {
        boolean bl;
        Item item = stack.m_41720_();
        if (item instanceof ItemStaffBase) {
            ItemStaffBase staff = (ItemStaffBase)item;
            if (staff.amount <= 1) {
                bl = true;
                return super.use(world, entity, stack, bl);
            }
        }
        bl = false;
        return super.use(world, entity, stack, bl);
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        Item item = stack.m_41720_();
        if (item instanceof ItemStaffBase) {
            ItemStaffBase staff = (ItemStaffBase)item;
            EnumElement element = ItemNBT.getElement(stack);
            if (element == EnumElement.NONE) {
                return false;
            }
            if (staff.amount == 1) {
                EntityElementalBall ball = new EntityElementalBall((Level)level, entity, element);
                Vec3 look = entity.m_20154_();
                ball.m_6686_(look.f_82479_, look.f_82480_, look.f_82481_, 1.0f, 0.0f);
                entity.f_19853_.m_7967_((Entity)ball);
            } else if (staff.amount == 2) {
                for (float offset : OFFSET_TWO) {
                    Vec3 side = MathUtils.rotate((Vec3)MathUtils.NORMAL_Y, (Vec3)MathUtils.NORMAL_X, (float)(-entity.m_146908_() * ((float)Math.PI / 180)));
                    Vec3 newPos = entity.m_20182_().m_82549_(side.m_82490_((double)offset)).m_82520_(0.0, (double)entity.m_20192_() - 0.1, 0.0);
                    EntityElementalBall ball = new EntityElementalBall((Level)level, entity, element);
                    Vec3 look = entity.m_20154_();
                    ball.m_6686_(look.f_82479_, look.f_82480_, look.f_82481_, 1.0f, 0.0f);
                    ball.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                    entity.f_19853_.m_7967_((Entity)ball);
                }
            } else {
                for (float offset : OFFSET_THREE) {
                    Vec3 side = MathUtils.rotate((Vec3)MathUtils.NORMAL_Y, (Vec3)MathUtils.NORMAL_X, (float)(-entity.m_146908_() * ((float)Math.PI / 180)));
                    Vec3 newPos = entity.m_20182_().m_82549_(side.m_82490_((double)offset)).m_82520_(0.0, (double)entity.m_20192_() - 0.1, 0.0);
                    EntityElementalBall ball = new EntityElementalBall((Level)level, entity, element);
                    Vec3 look = entity.m_20154_();
                    ball.m_6686_(look.f_82479_, look.f_82480_, look.f_82481_, 1.0f, 0.0f);
                    ball.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                    entity.f_19853_.m_7967_((Entity)ball);
                }
            }
            return true;
        }
        return false;
    }
}

