/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityBigRaccoonLeaf;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BigLeafSpell
extends Spell {
    private final boolean doubleShot;

    public BigLeafSpell(boolean doubleShot) {
        this.doubleShot = doubleShot;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int leafs = this.doubleShot ? 2 : 1;
        for (int i = 0; i < leafs; ++i) {
            EntityBigRaccoonLeaf leaf = new EntityBigRaccoonLeaf((Level)level, entity);
            leaf.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.1f));
            float vel = i % 2 == 0 ? 1.0f : 0.7f;
            ProjectileUtil.shoot(entity, leaf, vel, 0.0f);
            leaf.setDiameter(i % 2 == 0 ? 4.0 : 7.0);
            leaf.withRightSpin(i % 2 == 0);
            level.m_7967_((Entity)leaf);
        }
        BigLeafSpell.playSound(entity, (SoundEvent)ModSounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.2f);
        return true;
    }
}

