/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityBigPlate;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BigPlateSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        Mob mob;
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 pos = null;
        if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null) {
            pos = mob.m_5448_().m_20182_().m_82520_(0.0, (double)mob.m_5448_().m_20206_(), 0.0);
        }
        if (entity instanceof Player) {
            TargetingConditions target = TargetingConditions.m_148352_();
            target.m_26888_(e -> {
                if (e instanceof OwnableEntity) {
                    OwnableEntity ownable = (OwnableEntity)e;
                    if (e.m_142081_().equals(ownable.m_142504_())) {
                        return false;
                    }
                }
                if (!(e instanceof EntityNPCBase)) return true;
                EntityNPCBase npc = (EntityNPCBase)e;
                if (e.m_142081_().equals(npc.getEntityToFollowUUID())) return false;
                return true;
            });
            LivingEntity nearest = level.m_45963_(LivingEntity.class, target, entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_142469_().m_82400_(16.0));
            if (nearest != null) {
                pos = nearest.m_20182_().m_82520_(0.0, (double)nearest.m_20206_(), 0.0);
            }
        }
        if (pos == null) {
            Vec3 horizontalLook = new Vec3(entity.m_20154_().m_7096_(), 0.0, entity.m_20154_().m_7094_()).m_82541_();
            pos = entity.m_20182_().m_82549_(horizontalLook);
        }
        EntityBigPlate plate = new EntityBigPlate((Level)level, entity);
        plate.m_6034_(pos.m_7096_(), pos.m_7098_() + 4.0, pos.m_7094_());
        plate.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.25f));
        level.m_7967_((Entity)plate);
        return true;
    }
}

