/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityDarkBall;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DarkBallSpell
extends Spell {
    private final EntityDarkBall.Type type;

    public DarkBallSpell(EntityDarkBall.Type type) {
        this.type = type;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        EntityDarkBall ball = new EntityDarkBall((Level)level, entity, this.type);
        ball.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this.type == EntityDarkBall.Type.BALL ? 1.0f : 0.9f));
        float vel = this.type == EntityDarkBall.Type.BALL ? 0.09f : 0.23f;
        Vec3 target = ProjectileUtil.getAimTarget(entity, ball.m_20182_());
        if (target != null) {
            ball.shootAtPos(target, vel, 0.0f);
        } else {
            ball.shoot((Entity)entity, entity.m_146909_(), entity.m_146908_(), 0.0f, vel, 0.0f);
        }
        level.m_7967_((Entity)ball);
        DarkBallSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_DARK.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

