/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityWaterLaser;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DoubleWaterLaserSpell
extends Spell {
    private final float range;

    public DoubleWaterLaserSpell(float range) {
        this.range = range;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 dir = entity.m_20154_();
        Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - 0.1, 0.0);
        Vec3 targetPos = ProjectileUtil.getAimTarget(entity);
        if (targetPos != null) {
            dir = targetPos.m_82546_(pos);
        }
        UUID other = null;
        for (int i = 0; i < 2; ++i) {
            float posYawOff = (i == 0 ? -1 : 1) * 30;
            Vector3f vec = RayTraceUtils.rotatedAround((Vec3)dir.m_82541_(), (Vector3f)Vector3f.f_122225_, (float)posYawOff);
            EntityWaterLaser laser = new EntityWaterLaser((Level)level, entity);
            if (i == 0) {
                other = laser.m_142081_();
            } else {
                laser.setTwinId(other);
            }
            laser.setRange(this.range);
            laser.m_6034_(laser.m_20185_() + (double)vec.m_122239_(), laser.m_20186_() + (double)vec.m_122260_(), laser.m_20189_() + (double)vec.m_122269_());
            laser.setMaxTicks(entity instanceof Player ? Mth.m_14167_((float)PlayerModelAnimations.WATER_LASER_TWO.getLength()) : 15);
            laser.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.1f));
            Vec3 target = laser.m_20182_().m_82549_(dir);
            laser.setRotationTo(target.m_7096_(), target.m_7098_(), target.m_7094_(), 0.0f);
            laser.setPositionYawOffset(posYawOff);
            level.m_7967_((Entity)laser);
        }
        DoubleWaterLaserSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_WATER.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    @Override
    public AttackAction useAction() {
        return (AttackAction)((Object)ModAttackActions.DOUBLE_WATER_LASER_USE.get());
    }
}

