/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityElementalTrail;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElementalSpell
extends Spell {
    private final EnumElement element;

    public ElementalSpell(EnumElement element) {
        this.element = element;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        EntityElementalTrail flame = new EntityElementalTrail((Level)level, entity, this.element);
        flame.knockback();
        flame.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.9f));
        if (this.element == EnumElement.DARK) {
            Vec3 target = ProjectileUtil.getAimTarget(entity, flame.m_20182_());
            if (target != null) {
                flame.shootAtEntity(target, 0.05f, 0.0f);
            } else {
                flame.shoot((Entity)entity, entity.m_146909_(), entity.m_146908_(), 0.0f, 0.05f, 0.0f);
            }
        } else {
            Mob mob;
            Vec3 eye = entity.m_146892_();
            Vec3 dir = entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null ? mob.m_5448_().m_146892_().m_82546_(eye).m_82541_().m_82490_(1.4) : entity.m_20154_().m_82490_(1.4);
            flame.m_6034_(eye.f_82479_ + dir.f_82479_, eye.f_82480_ + dir.f_82480_, eye.f_82481_ + dir.f_82481_);
        }
        level.m_7967_((Entity)flame);
        return true;
    }
}

