/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityExplosionSpell;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ExplosionSpell
extends Spell {
    @Override
    public void levelSkill(ServerPlayer player) {
        Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.FIRE, 10.0f));
    }

    @Override
    public int coolDown() {
        return 25;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        EntityExplosionSpell spell = new EntityExplosionSpell((Level)level, entity);
        spell.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 1.25f));
        ProjectileUtil.shoot(entity, spell, 1.3f, 0.0f);
        level.m_7967_((Entity)spell);
        ExplosionSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

