/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityElementalBall;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IceBallDropSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        EntityElementalBall ball = new EntityElementalBall((Level)level, entity, EnumElement.WATER);
        ball.setVariant(1);
        Vec3 target = ProjectileUtil.getAimTarget(entity);
        if (target == null) {
            Vec3 vec3;
            HitResult res = RayTraceUtils.entityRayTrace((Entity)entity, (float)10.0f, (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY, (boolean)true, (boolean)true, null);
            if (res instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)res;
                vec3 = entityHitResult.m_82443_().m_146892_();
            } else {
                vec3 = res.m_82450_();
            }
            target = vec3;
        }
        ball.m_6034_(target.m_7096_(), target.m_7098_() + 5.0, target.m_7094_());
        ball.withMaxLivingTicks(25);
        ball.m_20256_(new Vec3(0.0, -1.0, 0.0).m_82490_(0.3));
        ball.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.9f));
        level.m_7967_((Entity)ball);
        IceBallDropSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

