/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMissile;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MissileSpell
extends Spell {
    private final int amount;

    public MissileSpell(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int left = this.amount / 2;
        Vec3 side = new Vec3(entity.m_20154_().f_82479_, 0.0, entity.m_20154_().f_82481_).m_82524_(90.0f).m_82541_();
        for (int i = 0; i < left; ++i) {
            EntityHitResult res;
            Mob mob;
            EntityMissile missile = new EntityMissile((Level)level, entity);
            missile.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.85f));
            missile.m_6034_(missile.m_20185_() + side.m_7096_() + entity.m_21187_().nextGaussian() * 0.1, missile.m_20186_(), missile.m_20189_() + side.m_7094_() + entity.m_21187_().nextGaussian() * 0.1);
            missile.shoot((Entity)entity, 0.0f, entity.m_146908_(), 0.0f, 0.18f, 8.0f);
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null) {
                missile.setTarget((Entity)mob.m_5448_());
            } else if (entity instanceof Player && (res = MissileSpell.calculateEntityFromLook(entity, 16.0f)) != null) {
                missile.setTarget(res.m_82443_());
            }
            level.m_7967_((Entity)missile);
        }
        int right = this.amount / left;
        for (int i = 0; i < right; ++i) {
            EntityHitResult res;
            Mob mob;
            EntityMissile missile = new EntityMissile((Level)level, entity);
            missile.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.9f));
            missile.m_6034_(missile.m_20185_() - side.m_7096_() + entity.m_21187_().nextGaussian() * 0.1, missile.m_20186_(), missile.m_20189_() - side.m_7094_() + entity.m_21187_().nextGaussian() * 0.1);
            missile.shoot((Entity)entity, 0.0f, entity.m_146908_(), 0.0f, 0.18f, 8.0f);
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null) {
                missile.setTarget((Entity)mob.m_5448_());
            } else if (entity instanceof Player && (res = MissileSpell.calculateEntityFromLook(entity, 16.0f)) != null) {
                missile.setTarget(res.m_82443_());
            }
            level.m_7967_((Entity)missile);
        }
        MissileSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, float reach) {
        Vec3 loc;
        double dist;
        Vec3 dir;
        Vec3 scaledDir;
        Vec3 pos = entity.m_20299_(1.0f);
        EntityHitResult result = RayTraceUtils.rayTraceEntities((Level)entity.f_19853_, (Entity)entity, (Vec3)pos, (Vec3)pos.m_82549_(scaledDir = (dir = entity.m_20252_(1.0f)).m_82490_((double)reach)), (AABB)entity.m_142469_().m_82369_(scaledDir).m_82400_(1.0), t -> EntitySelector.f_20408_.test(t) && t.m_6087_(), e -> e.m_6143_() + 1.0f);
        if (result != null && (dist = pos.m_82557_(loc = result.m_82450_())) <= (double)(reach * reach)) {
            return result;
        }
        return null;
    }
}

