/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMobArrow;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MultiArrowSpell
extends Spell {
    public final int amount;
    public final float damage;
    public final float angle;

    public MultiArrowSpell(int amount, float damage, float angle) {
        this.amount = amount;
        this.damage = damage;
        this.angle = angle;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        Vec3 dir;
        Mob mob;
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - 0.1, 0.0);
        float f = 1.0f;
        if (stack.m_41720_() instanceof ItemStaffBase) {
            f = BowItem.m_40661_((int)(72000 - entity.m_21212_()));
        }
        if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null) {
            Vec3 targetPos = EntityUtil.getStraightProjectileTarget((Vec3)pos, (Entity)mob.m_5448_());
            dir = new Vec3(targetPos.m_7096_() - pos.m_7096_(), targetPos.m_7098_() - pos.m_7098_(), targetPos.m_7094_() - pos.m_7094_());
        } else {
            dir = entity.m_20154_();
        }
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        float angle = -this.angle;
        float inc = this.angle * 2.0f / (float)(this.amount - 1);
        for (float y = angle; y <= this.angle; y += inc) {
            Quaternion quaternion = new Quaternion(new Vector3f(up), y, true);
            Vector3f newDir = new Vector3f(dir);
            newDir.m_122251_(quaternion);
            EntityMobArrow arrow = new EntityMobArrow((Level)level, entity, CombatUtils.getAbilityDamageBonus(lvl, this.damage));
            arrow.m_20254_(ItemNBT.getElement(stack) == EnumElement.FIRE ? 200 : 0);
            arrow.m_6686_(newDir.m_122239_(), newDir.m_122260_(), newDir.m_122269_(), f * 1.5f, 1.0f);
            level.m_7967_((Entity)arrow);
        }
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, entity.m_5720_(), 1.0f, 1.0f / (level.m_5822_().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        return true;
    }
}

