/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityFireball;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MultiFireballSpell
extends Spell {
    public final int amount;
    public final float damage;
    public final float angle;

    public MultiFireballSpell(int amount, float damage, float angle) {
        this.amount = amount;
        this.damage = damage;
        this.angle = angle;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - 0.1, 0.0);
        Vec3 target = ProjectileUtil.getAimTarget(entity);
        Vec3 dir = target != null ? target.m_82546_(pos) : entity.m_20154_();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        float angle = -this.angle;
        float inc = this.angle * 2.0f / (float)(this.amount - 1);
        for (float y = angle; y <= this.angle; y += inc) {
            Quaternion quaternion = new Quaternion(new Vector3f(up), y, true);
            Vector3f newDir = new Vector3f(dir);
            newDir.m_122251_(quaternion);
            EntityFireball other = new EntityFireball((Level)level, entity, false);
            other.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this.damage));
            other.m_6686_(newDir.m_122239_(), newDir.m_122260_(), newDir.m_122269_(), 1.0f, 0.0f);
            level.m_7967_((Entity)other);
        }
        MultiFireballSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

