/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PoisonHealSpell
extends Spell {
    public static void spawnStatusHealParticles(LivingEntity entity) {
        if (entity.f_19853_.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)entity.f_19853_;
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() + 0.5, entity.m_20189_(), 0, 0.0, 0.1, 0.0, 0.0);
        for (int i = 0; i < 16; ++i) {
            serverLevel.m_8767_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.LIGHT.get(), 0.22352941f, 0.4392157f, 0.7019608f, 0.5f, 2.0f), entity.m_20208_(1.2), entity.m_20186_() + (double)entity.m_20206_() * 0.5 + entity.m_21187_().nextGaussian() * 0.5 * (double)entity.m_20206_() * 0.3, entity.m_20262_(1.2), 1, entity.m_21187_().nextGaussian() * 0.03, entity.m_21187_().nextGaussian() * 0.03, entity.m_21187_().nextGaussian() * 0.03, 0.0);
        }
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Consumer<LivingEntity> apply = living -> {
            if (lvl >= 10) {
                living.m_21195_((MobEffect)ModEffects.SEAL.get());
            }
            if (lvl >= 5) {
                living.m_21195_((MobEffect)ModEffects.PARALYSIS.get());
                living.m_21195_(MobEffects.f_19615_);
            }
            living.m_21195_(MobEffects.f_19614_);
            living.m_21195_((MobEffect)ModEffects.POISON.get());
            PoisonHealSpell.spawnStatusHealParticles(living);
        };
        List entities = level.m_6443_(LivingEntity.class, entity.m_142469_().m_82400_(12.0), e -> {
            if (e == entity) {
                return true;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (e instanceof OwnableEntity) {
                    OwnableEntity ownable = (OwnableEntity)e;
                    if (player.m_142081_().equals(ownable.m_142504_())) return true;
                }
                if (e instanceof AbstractVillager) return true;
                if (e instanceof Animal) return true;
                if (Platform.INSTANCE.getPlayerData(player).map(d -> d.party.isPartyMember((Entity)e)).orElse(false) == false) return false;
                return true;
            }
            if (!(entity instanceof HealingPredicateEntity)) return false;
            HealingPredicateEntity healer = (HealingPredicateEntity)entity;
            return healer.healeableEntities().test((LivingEntity)e);
        });
        apply.accept(entity);
        entities.forEach(apply);
        PoisonHealSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_HEAL.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

